/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.oauth;

import com.databricks.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.internal.fasterxml.jackson.databind.node.ObjectNode;
import com.databricks.internal.google.common.base.Strings;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.HttpClient;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.core.http.Response;
import com.databricks.internal.sdk.core.oauth.IDToken;
import com.databricks.internal.sdk.core.oauth.IDTokenSource;
import com.databricks.internal.sdk.core.utils.Environment;
import java.io.File;
import java.io.IOException;

public class AzureDevOpsIDTokenSource
implements IDTokenSource {
    private final String azureDevOpsAccessToken;
    private final String azureDevOpsTeamFoundationCollectionUri;
    private final String azureDevOpsPlanId;
    private final String azureDevOpsJobId;
    private final String azureDevOpsTeamProjectId;
    private final String azureDevOpsHostType;
    private final HttpClient httpClient;
    private final Environment environment;
    private static final ObjectMapper mapper = new ObjectMapper();

    public AzureDevOpsIDTokenSource(HttpClient httpClient) {
        this(httpClient, AzureDevOpsIDTokenSource.createDefaultEnvironment());
    }

    protected AzureDevOpsIDTokenSource(HttpClient httpClient, Environment environment) {
        if (httpClient == null) {
            throw new DatabricksException("HttpClient cannot be null");
        }
        this.httpClient = httpClient;
        this.environment = environment;
        this.azureDevOpsAccessToken = this.validateEnvironmentVariable("SYSTEM_ACCESSTOKEN");
        this.azureDevOpsTeamFoundationCollectionUri = this.validateEnvironmentVariable("SYSTEM_TEAMFOUNDATIONCOLLECTIONURI");
        this.azureDevOpsPlanId = this.validateEnvironmentVariable("SYSTEM_PLANID");
        this.azureDevOpsJobId = this.validateEnvironmentVariable("SYSTEM_JOBID");
        this.azureDevOpsTeamProjectId = this.validateEnvironmentVariable("SYSTEM_TEAMPROJECTID");
        this.azureDevOpsHostType = this.validateEnvironmentVariable("SYSTEM_HOSTTYPE");
    }

    private static Environment createDefaultEnvironment() {
        String pathEnv = System.getenv("PATH");
        String[] pathArray = pathEnv != null ? pathEnv.split(File.pathSeparator) : new String[]{};
        return new Environment(System.getenv(), pathArray, System.getProperty("os.name"));
    }

    private String validateEnvironmentVariable(String varName) {
        String value = this.environment.get(varName);
        if (Strings.isNullOrEmpty(value)) {
            if (varName.equals("SYSTEM_ACCESSTOKEN")) {
                throw new DatabricksException(String.format("Missing environment variable %s, if calling from Azure DevOps Pipeline, please set this env var following https://learn.microsoft.com/en-us/azure/devops/pipelines/build/variables?view=azure-devops&tabs=yaml#systemaccesstoken", varName));
            }
            throw new DatabricksException(String.format("Missing environment variable %s, likely not calling from Azure DevOps Pipeline", varName));
        }
        return value;
    }

    @Override
    public IDToken getIDToken(String audience) {
        ObjectNode jsonResp;
        Response resp;
        String requestUrl = String.format("%s/%s/_apis/distributedtask/hubs/%s/plans/%s/jobs/%s/oidctoken?api-version=7.2-preview.1", this.azureDevOpsTeamFoundationCollectionUri, this.azureDevOpsTeamProjectId, this.azureDevOpsHostType, this.azureDevOpsPlanId, this.azureDevOpsJobId);
        Request req = new Request("POST", requestUrl).withHeader("Authorization", "Bearer " + this.azureDevOpsAccessToken).withHeader("Content-Type", "application/json");
        try {
            resp = this.httpClient.execute(req);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request ID token from Azure DevOps at " + requestUrl + ": " + e.getMessage(), e);
        }
        if (resp.getStatusCode() != 200) {
            throw new DatabricksException("Failed to request ID token from Azure DevOps: status code " + resp.getStatusCode() + ", response body: " + resp.getBody().toString());
        }
        try {
            jsonResp = mapper.readValue(resp.getBody(), ObjectNode.class);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to parse Azure DevOps OIDC token response: " + e.getMessage(), e);
        }
        if (!jsonResp.has("oidcToken")) {
            throw new DatabricksException("Azure DevOps OIDC token response missing 'oidcToken' field");
        }
        String tokenValue = jsonResp.get("oidcToken").textValue();
        if (Strings.isNullOrEmpty(tokenValue)) {
            throw new DatabricksException("Received empty OIDC token from Azure DevOps");
        }
        return new IDToken(tokenValue);
    }
}

