/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.nimbusds.jose.util;

import com.databricks.internal.nimbusds.jose.shaded.gson.Gson;
import com.databricks.internal.nimbusds.jose.shaded.gson.GsonBuilder;
import com.databricks.internal.nimbusds.jose.shaded.gson.Strictness;
import com.databricks.internal.nimbusds.jose.shaded.gson.ToNumberPolicy;
import com.databricks.internal.nimbusds.jose.shaded.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JSONArrayUtils {
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.STRICT).serializeNulls().setObjectToNumberStrategy(ToNumberPolicy.LONG_OR_DOUBLE).disableHtmlEscaping().create();

    public static List<Object> parse(String s2) throws ParseException {
        if (s2 == null) {
            throw new ParseException("The JSON array string must not be null", 0);
        }
        if (s2.trim().isEmpty()) {
            throw new ParseException("Invalid JSON array", 0);
        }
        Type listType = TypeToken.getParameterized(List.class, new Type[]{Object.class}).getType();
        try {
            return (List)GSON.fromJson(s2, listType);
        }
        catch (Exception e) {
            throw new ParseException("Invalid JSON array", 0);
        }
        catch (StackOverflowError e) {
            throw new ParseException("Excessive JSON object and / or array nesting", 0);
        }
    }

    public static String toJSONString(List<?> jsonArray) {
        return GSON.toJson(Objects.requireNonNull(jsonArray));
    }

    public static List<Object> newJSONArray() {
        return new ArrayList<Object>();
    }

    private JSONArrayUtils() {
    }
}

