/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.noding.snap;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateList;
import com.databricks.internal.jts.math.MathUtil;
import com.databricks.internal.jts.noding.MCIndexNoder;
import com.databricks.internal.jts.noding.NodedSegmentString;
import com.databricks.internal.jts.noding.Noder;
import com.databricks.internal.jts.noding.SegmentString;
import com.databricks.internal.jts.noding.snap.SnappingIntersectionAdder;
import com.databricks.internal.jts.noding.snap.SnappingPointIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SnappingNoder
implements Noder {
    private SnappingPointIndex snapIndex;
    private double snapTolerance;
    private List<NodedSegmentString> nodedResult;

    public SnappingNoder(double snapTolerance) {
        this.snapTolerance = snapTolerance;
        this.snapIndex = new SnappingPointIndex(snapTolerance);
    }

    @Override
    public Collection getNodedSubstrings() {
        return this.nodedResult;
    }

    @Override
    public void computeNodes(Collection inputSegStrings) {
        List<NodedSegmentString> snappedSS = this.snapVertices(inputSegStrings);
        this.nodedResult = (List)this.snapIntersections(snappedSS);
    }

    private List<NodedSegmentString> snapVertices(Collection<SegmentString> segStrings) {
        this.seedSnapIndex(segStrings);
        ArrayList<NodedSegmentString> nodedStrings = new ArrayList<NodedSegmentString>();
        for (SegmentString ss : segStrings) {
            nodedStrings.add(this.snapVertices(ss));
        }
        return nodedStrings;
    }

    private void seedSnapIndex(Collection<SegmentString> segStrings) {
        int SEED_SIZE_FACTOR = 100;
        for (SegmentString ss : segStrings) {
            Coordinate[] pts = ss.getCoordinates();
            int numPtsToLoad = pts.length / 100;
            double rand = 0.0;
            for (int i = 0; i < numPtsToLoad; ++i) {
                rand = MathUtil.quasirandom(rand);
                int index = (int)((double)pts.length * rand);
                this.snapIndex.snap(pts[index]);
            }
        }
    }

    private NodedSegmentString snapVertices(SegmentString ss) {
        Coordinate[] snapCoords = this.snap(ss.getCoordinates());
        return new NodedSegmentString(snapCoords, ss.getData());
    }

    private Coordinate[] snap(Coordinate[] coords) {
        CoordinateList snapCoords = new CoordinateList();
        for (int i = 0; i < coords.length; ++i) {
            Coordinate pt = this.snapIndex.snap(coords[i]);
            snapCoords.add(pt, false);
        }
        return snapCoords.toCoordinateArray();
    }

    private Collection snapIntersections(List<NodedSegmentString> inputSS) {
        SnappingIntersectionAdder intAdder = new SnappingIntersectionAdder(this.snapTolerance, this.snapIndex);
        MCIndexNoder noder = new MCIndexNoder(intAdder, 2.0 * this.snapTolerance);
        noder.computeNodes(inputSS);
        return noder.getNodedSubstrings();
    }
}

