/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.index.bintree;

import com.databricks.internal.jts.index.bintree.Interval;
import com.databricks.internal.jts.index.bintree.Node;
import com.databricks.internal.jts.index.bintree.NodeBase;
import com.databricks.internal.jts.index.quadtree.IntervalSize;
import com.databricks.internal.jts.util.Assert;

public class Root
extends NodeBase {
    private static final double origin = 0.0;

    public void insert(Interval itemInterval, Object item) {
        int index = Root.getSubnodeIndex(itemInterval, 0.0);
        if (index == -1) {
            this.add(item);
            return;
        }
        Node node = this.subnode[index];
        if (node == null || !node.getInterval().contains(itemInterval)) {
            Node largerNode;
            this.subnode[index] = largerNode = Node.createExpanded(node, itemInterval);
        }
        this.insertContained(this.subnode[index], itemInterval, item);
    }

    private void insertContained(Node tree, Interval itemInterval, Object item) {
        Assert.isTrue(tree.getInterval().contains(itemInterval));
        boolean isZeroArea = IntervalSize.isZeroWidth(itemInterval.getMin(), itemInterval.getMax());
        NodeBase node = isZeroArea ? tree.find(itemInterval) : tree.getNode(itemInterval);
        node.add(item);
    }

    @Override
    protected boolean isSearchMatch(Interval interval) {
        return true;
    }
}

