/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.geom;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateSequence;
import com.databricks.internal.jts.geom.CoordinateSequences;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.PrecisionModel;

public class LinearRing
extends LineString {
    public static final int MINIMUM_VALID_SIZE = 3;
    private static final long serialVersionUID = -4261142084085851829L;

    public LinearRing(Coordinate[] points, PrecisionModel precisionModel, int SRID) {
        this(points, new GeometryFactory(precisionModel, SRID));
        this.validateConstruction();
    }

    private LinearRing(Coordinate[] points, GeometryFactory factory) {
        this(factory.getCoordinateSequenceFactory().create(points), factory);
    }

    public LinearRing(CoordinateSequence points, GeometryFactory factory) {
        super(points, factory);
        this.validateConstruction();
    }

    private void validateConstruction() {
        if (!this.isEmpty() && !super.isClosed()) {
            throw new IllegalArgumentException("Points of LinearRing do not form a closed linestring");
        }
        if (this.getCoordinateSequence().size() >= 1 && this.getCoordinateSequence().size() < 3) {
            throw new IllegalArgumentException("Invalid number of points in LinearRing (found " + this.getCoordinateSequence().size() + " - must be 0 or >= " + 3 + ")");
        }
    }

    @Override
    public int getBoundaryDimension() {
        return -1;
    }

    @Override
    public boolean isClosed() {
        if (this.isEmpty()) {
            return true;
        }
        return super.isClosed();
    }

    @Override
    public String getGeometryType() {
        return "LinearRing";
    }

    @Override
    protected int getTypeCode() {
        return 3;
    }

    @Override
    protected LinearRing copyInternal() {
        return new LinearRing(this.points.copy(), this.factory);
    }

    @Override
    public LinearRing reverse() {
        return (LinearRing)super.reverse();
    }

    @Override
    public LinearRing reverseInternal() {
        CoordinateSequence seq = this.points.copy();
        CoordinateSequences.reverse(seq);
        return this.getFactory().createLinearRing(seq);
    }
}

