/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.commons.io.function;

import com.databricks.internal.apache.commons.io.function.IOIterator;
import com.databricks.internal.apache.commons.io.function.Uncheck;
import java.util.Iterator;
import java.util.Objects;

final class UncheckedIOIterator<E>
implements Iterator<E> {
    private final IOIterator<E> delegate;

    UncheckedIOIterator(IOIterator<E> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public boolean hasNext() {
        return Uncheck.get(this.delegate::hasNext);
    }

    @Override
    public E next() {
        return (E)Uncheck.get(this.delegate::next);
    }

    @Override
    public void remove() {
        Uncheck.run(this.delegate::remove);
    }
}

