/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.internal.apache.http.config.Registry;
import com.databricks.internal.apache.http.config.RegistryBuilder;
import com.databricks.internal.apache.http.conn.socket.ConnectionSocketFactory;
import com.databricks.internal.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.databricks.internal.apache.http.conn.ssl.NoopHostnameVerifier;
import com.databricks.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SocketFactoryUtil {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(SocketFactoryUtil.class);

    public static Registry<ConnectionSocketFactory> getTrustAllSocketFactoryRegistry() {
        LOGGER.warn("This driver is configured to trust all SSL certificates. This is insecure and should never be used in production.");
        try {
            TrustManager[] trustAllCerts = SocketFactoryUtil.getTrustManagerThatTrustsAllCertificates();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            return RegistryBuilder.create().register("https", sslSocketFactory).register("http", (SSLConnectionSocketFactory)((Object)new PlainConnectionSocketFactory())).build();
        }
        catch (Exception e) {
            String errorMessage = "Error while setting up trust-all SSL context.";
            LOGGER.error(errorMessage, e);
            throw new DatabricksException(errorMessage, e);
        }
    }

    public static TrustManager[] getTrustManagerThatTrustsAllCertificates() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }
}

