/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor;

import com.databricks.client.dsi.core.impl.DSIDriver;
import com.databricks.client.dsi.dataengine.impl.DSISimpleResultSet;
import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.CursorType;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.dsi.utilities.DSIMessageKey;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.etree.ETCancelState;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.ETResourceManager;
import com.databricks.client.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.databricks.client.sqlengine.executor.etree.statement.ETQuery;
import com.databricks.client.sqlengine.executor.etree.util.RegisterWarningListenerUtil;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import com.databricks.client.support.exceptions.InvalidOperationException;
import java.util.List;

public class ETResultSet
extends DSISimpleResultSet {
    private final List<IColumn> m_columns;
    private boolean m_isCursorSet;
    private ETRelationalExpr m_etRelation;
    private ETResourceManager m_rscManager;
    private final ETCancelState m_cancelState;

    public ETResultSet(ETQuery eTQuery, AEQuery aEQuery, ETResourceManager eTResourceManager, ETCancelState eTCancelState) {
        this.m_etRelation = eTQuery.getOperand();
        this.m_isCursorSet = false;
        this.m_rscManager = eTResourceManager;
        this.m_columns = aEQuery.createResultSetColumns();
        this.m_cancelState = eTCancelState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.m_cancelState.cancel();
        ETResultSet eTResultSet = this;
        synchronized (eTResultSet) {
            try {
                if (this.m_isCursorSet) {
                    this.m_etRelation.close(false);
                }
            }
            finally {
                if (this.m_isCursorSet) {
                    this.m_rscManager.free();
                }
                this.m_isCursorSet = false;
                super.close();
            }
        }
    }

    @Override
    public synchronized boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        if (!this.m_isCursorSet) {
            throw new InvalidOperationException(7, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{"getData() called when the cursor is not set."});
        }
        if (this.m_cancelState.isCanceled()) {
            throw SQLEngineExceptionFactory.operationCanceledException();
        }
        ETDataRequest eTDataRequest = new ETDataRequest(l, l2, this.m_columns.get(n));
        boolean bl = this.m_etRelation.retrieveData(n, eTDataRequest);
        eTDataRequest.getData().retrieveData(dataWrapper);
        return bl;
    }

    @Override
    public synchronized long getRowCount() throws ErrorException {
        return this.m_etRelation.getRowCount();
    }

    @Override
    public List<? extends IColumn> getSelectColumns() throws ErrorException {
        return this.m_columns;
    }

    @Override
    public final boolean hasMoreRows() throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("IResult.hasMoreRows()");
    }

    @Override
    public boolean hasRowCount() {
        try {
            return -1L != this.getRowCount();
        }
        catch (ErrorException errorException) {
            return false;
        }
    }

    @Override
    public synchronized boolean moveToNextRow() throws ErrorException {
        if (!this.m_isCursorSet) {
            throw new InvalidOperationException(7, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{"moveToNextRow() called when the cursor is not set."});
        }
        if (this.m_cancelState.isCanceled()) {
            throw SQLEngineExceptionFactory.operationCanceledException();
        }
        return this.m_etRelation.move();
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        RegisterWarningListenerUtil.registerWarningListener(iWarningListener, this.m_etRelation);
        super.registerWarningListener(iWarningListener);
    }

    @Override
    public synchronized void setCursorType(CursorType cursorType) throws ErrorException {
        if (CursorType.FORWARD_ONLY != cursorType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CURSOR_NOT_SUPPORTED.name(), String.valueOf((Object)cursorType));
        }
        try {
            if (!this.m_isCursorSet) {
                this.m_rscManager.allocate();
                this.m_etRelation.open(cursorType);
                this.m_isCursorSet = true;
            }
        }
        catch (ErrorException errorException) {
            this.m_rscManager.free();
            throw errorException;
        }
        catch (RuntimeException runtimeException) {
            this.m_rscManager.free();
            throw runtimeException;
        }
        catch (Error error) {
            this.m_rscManager.free();
            throw error;
        }
    }

    @Override
    public final boolean supportsHasMoreRows() {
        return false;
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        this.close();
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        throw new IllegalStateException("Method should not be called as moveToNextRow() is implemented directly.");
    }
}

