/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.dsiext.dataengine;

import com.databricks.client.dsi.dataengine.impl.DSIMetadataOnlyResultSet;
import com.databricks.client.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.interfaces.IQueryExecutor;
import com.databricks.client.dsi.dataengine.utilities.ColumnMetadata;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.dsi.dataengine.utilities.ExecutionContext;
import com.databricks.client.dsi.dataengine.utilities.ExecutionContexts;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResult;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResults;
import com.databricks.client.dsi.dataengine.utilities.ParameterInputValue;
import com.databricks.client.dsi.dataengine.utilities.ParameterMetadata;
import com.databricks.client.dsi.dataengine.utilities.ParameterType;
import com.databricks.client.dsi.dataengine.utilities.TypeMetadata;
import com.databricks.client.dsi.dataengine.utilities.TypeUtilities;
import com.databricks.client.dsi.exceptions.BadDefaultParamException;
import com.databricks.client.dsi.exceptions.DefaultParamException;
import com.databricks.client.dsi.exceptions.ExecutingException;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.dsi.exceptions.InvalidArgumentException;
import com.databricks.client.dsi.exceptions.NumericOverflowException;
import com.databricks.client.dsi.exceptions.OperationCanceledException;
import com.databricks.client.dsi.exceptions.ParamAlreadyPushedException;
import com.databricks.client.dsi.exceptions.ParsingException;
import com.databricks.client.sqlengine.aeprocessor.aeoptimizer.AEPassdownOpOptimizer;
import com.databricks.client.sqlengine.aeprocessor.aeoptimizer.AETreeOptimizer;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEProcedureCall;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AERowCountStatement;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.databricks.client.sqlengine.dsiext.dataengine.AbstractExecutionContext;
import com.databricks.client.sqlengine.dsiext.dataengine.BatchExecutionContext;
import com.databricks.client.sqlengine.dsiext.dataengine.DSIExtOperationHandlerFactory;
import com.databricks.client.sqlengine.dsiext.dataengine.IExecutionContext;
import com.databricks.client.sqlengine.dsiext.dataengine.SingleExecutionContext;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlQueryExecutorContext;
import com.databricks.client.sqlengine.exceptions.SQLEngineException;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.exceptions.SQLEngineRuntimeException;
import com.databricks.client.sqlengine.executor.IStatementExecutor;
import com.databricks.client.sqlengine.executor.etree.ETCancelState;
import com.databricks.client.sqlengine.executor.materializer.ETStatementMaterializer;
import com.databricks.client.sqlengine.executor.queryplan.ETQueryPlan;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.DiagState;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SqlQueryExecutor
implements IQueryExecutor {
    protected AEStatements m_aeStatements;
    protected ILogger m_log;
    private SqlQueryExecutorContext m_context;
    private ExecutionResults m_results;
    private Map<Integer, Map<Integer, ArrayList<ParameterInputValue>>> m_unprocessedPushedValues;
    private Map<Integer, ParameterInputValue[]> m_pushedValues;
    private List<ParameterMetadata> m_parameterMetadata = null;
    private SqlDataEngineContext m_dataEngineContext;
    private DSIExtOperationHandlerFactory m_opHandlerFactory;
    private List<ETCancelState> m_cancelStates = null;
    private Object m_cancelLock = new Object();

    public SqlQueryExecutor(AEStatements aEStatements, SqlDataEngineContext sqlDataEngineContext, ILogger iLogger) throws ErrorException {
        this.m_log = iLogger;
        this.m_context = new SqlQueryExecutorContext(sqlDataEngineContext, this);
        this.m_unprocessedPushedValues = new HashMap<Integer, Map<Integer, ArrayList<ParameterInputValue>>>();
        this.m_dataEngineContext = sqlDataEngineContext;
        this.m_aeStatements = new AEStatements();
        AETreeOptimizer aETreeOptimizer = new AETreeOptimizer(this.m_context);
        Iterator<IAEStatement> iterator = aEStatements.getStatementItr();
        assert (iterator.hasNext());
        while (iterator.hasNext()) {
            IAEStatement iAEStatement = iterator.next();
            aETreeOptimizer.optimize(iAEStatement);
            this.m_aeStatements.addStatement(iAEStatement);
        }
        this.prepareResults();
        this.m_opHandlerFactory = this.m_dataEngineContext.getDataEngine().createOperationHandlerFactory();
    }

    public void prepareResults() throws ErrorException {
        this.m_results = SqlQueryExecutor.createMetadataResults(this.m_aeStatements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelExecute() throws ErrorException {
        Object object = this.m_cancelLock;
        synchronized (object) {
            this.m_context.setIsCanceled(true);
            if (this.m_cancelStates != null) {
                for (ETCancelState eTCancelState : this.m_cancelStates) {
                    eTCancelState.cancel();
                }
            }
            this.clearPushedParamData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCancel() {
        Object object = this.m_cancelLock;
        synchronized (object) {
            this.m_context.setIsCanceled(false);
            this.m_cancelStates = null;
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, OperationCanceledException, ErrorException {
        try {
            Object object;
            this.m_results = null;
            if ((executionContexts.getIsPreparedStatementBatchExecution() || executionContexts.getCount() > 1) && this.m_aeStatements.size() > 1) {
                throw SQLEngineExceptionFactory.featureNotImplementedException("Batch executions with compound statements not supported.");
            }
            if (this.m_opHandlerFactory != null) {
                this.m_opHandlerFactory.setParameterSetCount(executionContexts.getCount());
            }
            this.m_context.setWarningListener(iWarningListener);
            ArrayList<IStatementExecutor> arrayList = new ArrayList<IStatementExecutor>(this.m_aeStatements.getNumChildren());
            ArrayList<ETCancelState> arrayList2 = new ArrayList<ETCancelState>(this.m_aeStatements.getNumChildren());
            Iterator<IAEStatement> iterator = this.m_aeStatements.getStatementItr();
            while (iterator.hasNext()) {
                object = iterator.next();
                this.updateParamMetadata((IAEStatement)object, executionContexts);
                if (this.m_opHandlerFactory != null) {
                    object = (IAEStatement)object.copy();
                    if (executionContexts.getCount() == 1) {
                        this.pushParameterToAETree(executionContexts.contextIterator().next(), (IAEStatement)object);
                    }
                }
                ETQueryPlan eTQueryPlan = new ETQueryPlan(this.doPassdownOptimize((IAEStatement)object));
                IStatementExecutor iStatementExecutor = new ETStatementMaterializer(this.m_context.getDataEngineContext().getDataEngine().createSqlConverterGenerator(), iWarningListener, this.m_dataEngineContext, this.m_log).materialize(eTQueryPlan);
                arrayList.add(iStatementExecutor);
                arrayList2.add(iStatementExecutor.getCancelState());
                if (!iStatementExecutor.generatesResultSet() || executionContexts.getCount() <= 1) continue;
                throw SQLEngineExceptionFactory.featureNotImplementedException("Batch execution generating multiple active open result sets is not supported.");
            }
            object = this.m_cancelLock;
            synchronized (object) {
                if (this.m_context.isCanceled()) {
                    throw SQLEngineExceptionFactory.operationCanceledException();
                }
                this.m_cancelStates = arrayList2;
            }
            object = executionContexts.getIsPreparedStatementBatchExecution() || executionContexts.getCount() > 1 ? new BatchExecutionContext((IStatementExecutor)arrayList.get(0), executionContexts, this.m_pushedValues, (ETCancelState)arrayList2.get(0), this.shouldContinueMultiParamSetExecutionOnError()) : new SingleExecutionContext(arrayList, executionContexts, this.m_pushedValues, (ETCancelState)arrayList2.get(0));
            this.m_dataEngineContext.getDataEngine().onBeginExecution((IExecutionContext)object);
            try {
                this.m_results = ((AbstractExecutionContext)object).execute(iWarningListener);
            }
            finally {
                this.m_dataEngineContext.getDataEngine().onExecutionComplete();
            }
        }
        catch (SQLEngineRuntimeException sQLEngineRuntimeException) {
            throw SQLEngineExceptionFactory.convertRuntimeException(sQLEngineRuntimeException);
        }
        finally {
            this.clearPushedParamData();
        }
    }

    private boolean shouldContinueMultiParamSetExecutionOnError() throws ErrorException {
        try {
            long l = this.m_dataEngineContext.getConnProperty(177).getLong();
            return 0L == (l & 2L);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new RuntimeException(incorrectTypeException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new RuntimeException(numericOverflowException);
        }
    }

    private void updateParamMetadata(IAEStatement iAEStatement, ExecutionContexts executionContexts) throws ErrorException {
        assert (executionContexts.getCount() > 0);
        List<? extends ParameterMetadata> list = executionContexts.getMetadata();
        HashMap<Integer, TypeMetadata> hashMap = new HashMap<Integer, TypeMetadata>();
        boolean bl = false;
        for (AEParameter aEParameter : iAEStatement.getDynamicParameters()) {
            TypeMetadata typeMetadata = list.get(aEParameter.getIndex() - 1).getTypeMetadata();
            if (aEParameter.getParameterType() != ParameterType.INPUT && aEParameter.getParameterType() != ParameterType.INPUT_OUTPUT || aEParameter.getColumn().getTypeMetadata().getType() == typeMetadata.getType()) continue;
            bl = true;
            hashMap.put(aEParameter.getIndex() - 1, TypeMetadata.copyOf(typeMetadata));
        }
        if (bl) {
            this.pushMappedParamTypes(hashMap);
        }
    }

    private void pushParameterToAETree(ExecutionContext executionContext, IAEStatement iAEStatement) throws SQLEngineException, OperationCanceledException {
        for (AEParameter aEParameter : iAEStatement.getDynamicParameters()) {
            ParameterInputValue parameterInputValue = executionContext.getInputs().get(aEParameter.getIndex() - 1);
            if (parameterInputValue.isDefaultValue()) continue;
            try {
                if (parameterInputValue.isPushed()) {
                    aEParameter.setInputData(this.getPushedParam(1, aEParameter.getIndex()).getData());
                    continue;
                }
                aEParameter.setInputData(parameterInputValue.getData());
            }
            catch (ParamAlreadyPushedException paramAlreadyPushedException) {
                throw new IllegalStateException("Pushed parameter constructed.");
            }
            catch (DefaultParamException defaultParamException) {
                assert (false);
            }
        }
    }

    @Override
    public void clearPushedParamData() throws ErrorException {
        this.m_pushedValues = null;
        this.m_unprocessedPushedValues = new HashMap<Integer, Map<Integer, ArrayList<ParameterInputValue>>>();
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, ErrorException {
        try {
            Integer n2;
            ArrayList<ParameterInputValue> arrayList;
            Map<Integer, ArrayList<ParameterInputValue>> map = this.getUnprocessedPushedValues().get(n);
            if (null == map) {
                map = new HashMap<Integer, ArrayList<ParameterInputValue>>();
                this.getUnprocessedPushedValues().put(n, map);
            }
            if (null == (arrayList = map.get(n2 = Integer.valueOf(parameterInputValue.getMetadata().getParameterNumber())))) {
                arrayList = new ArrayList();
                map.put(n2, arrayList);
            }
            arrayList.add(parameterInputValue);
        }
        catch (Exception exception) {
            throw new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, exception.getLocalizedMessage());
        }
    }

    @Override
    public void finalizePushedParamData() throws ErrorException {
        if (this.getNumParams() == 0 || this.m_unprocessedPushedValues.size() == 0) {
            return;
        }
        List<ParameterMetadata> list = this.getMetadataForParameters();
        HashMap<Integer, ParameterInputValue[]> hashMap = new HashMap<Integer, ParameterInputValue[]>();
        try {
            for (Map.Entry<Integer, Map<Integer, ArrayList<ParameterInputValue>>> entry : this.getUnprocessedPushedValues().entrySet()) {
                Map<Integer, ArrayList<ParameterInputValue>> map = entry.getValue();
                Integer n = entry.getKey();
                ParameterInputValue[] parameterInputValueArray = new ParameterInputValue[this.getNumParams() + 1];
                hashMap.put(n, parameterInputValueArray);
                for (Map.Entry<Integer, ArrayList<ParameterInputValue>> entry2 : map.entrySet()) {
                    DataWrapper dataWrapper;
                    int n2;
                    block24: {
                        ByteArrayOutputStream byteArrayOutputStream;
                        block23: {
                            n2 = entry2.getKey();
                            ArrayList<ParameterInputValue> arrayList = entry2.getValue();
                            if (arrayList.size() <= 1) {
                                if (arrayList.size() != 1) continue;
                                parameterInputValueArray[n2] = arrayList.get(0);
                                parameterInputValueArray[n2].setPushed(false);
                                continue;
                            }
                            dataWrapper = new DataWrapper();
                            StringBuilder stringBuilder = new StringBuilder(8000);
                            byteArrayOutputStream = new ByteArrayOutputStream(8000);
                            boolean bl = TypeUtilities.isCharacterType(arrayList.get(0).getMetadata().getTypeMetadata().getType());
                            for (ParameterInputValue parameterInputValue : arrayList) {
                                DataWrapper dataWrapper2 = parameterInputValue.getData();
                                Object object = dataWrapper2.getObject();
                                if (bl) {
                                    stringBuilder.append((String)parameterInputValue.getData().getObject());
                                    continue;
                                }
                                byteArrayOutputStream.write((byte[])object);
                            }
                            if (!bl) break block23;
                            switch (list.get(n2 - 1).getTypeMetadata().getType()) {
                                case 1: {
                                    dataWrapper.setChar(stringBuilder.toString());
                                    break block24;
                                }
                                case 12: {
                                    dataWrapper.setVarChar(stringBuilder.toString());
                                    break block24;
                                }
                                case -1: {
                                    dataWrapper.setLongVarChar(stringBuilder.toString());
                                    break block24;
                                }
                                case -8: {
                                    dataWrapper.setWChar(stringBuilder.toString());
                                    break block24;
                                }
                                case -9: {
                                    dataWrapper.setWVarChar(stringBuilder.toString());
                                    break block24;
                                }
                                case -10: {
                                    dataWrapper.setWLongVarChar(stringBuilder.toString());
                                    break block24;
                                }
                                default: {
                                    throw new IllegalStateException("Unknown type.");
                                }
                            }
                        }
                        switch (list.get(n2 - 1).getTypeMetadata().getType()) {
                            case -2: {
                                dataWrapper.setBinary(byteArrayOutputStream.toByteArray());
                                break;
                            }
                            case -3: {
                                dataWrapper.setVarBinary(byteArrayOutputStream.toByteArray());
                                break;
                            }
                            case -4: {
                                dataWrapper.setLongVarBinary(byteArrayOutputStream.toByteArray());
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown type.");
                            }
                        }
                    }
                    parameterInputValueArray[n2] = new ParameterInputValue(list.get(n2 - 1), dataWrapper);
                }
            }
            if (this.m_context.isCanceled()) {
                throw SQLEngineExceptionFactory.operationCanceledException();
            }
            this.m_pushedValues = hashMap;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, exception.getLocalizedMessage());
        }
    }

    public SqlQueryExecutorContext getContext() {
        return this.m_context;
    }

    public List<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        if (this.m_parameterMetadata == null) {
            int n = 0;
            ArrayList<ParameterMetadata> arrayList = new ArrayList<ParameterMetadata>();
            Iterator<IAEStatement> iterator = this.m_aeStatements.getStatementItr();
            while (iterator.hasNext()) {
                IAEStatement iAEStatement = iterator.next();
                List<AEParameter> list = iAEStatement.getDynamicParameters();
                for (AEParameter aEParameter : list) {
                    IColumn iColumn = aEParameter.getInferredOrSetColumn();
                    ParameterMetadata parameterMetadata = new ParameterMetadata(aEParameter.getIndex() + n, aEParameter.getParameterType(), iColumn.getTypeMetadata(), iColumn.getName(), iColumn.isCaseSensitive(), iColumn.getNullable());
                    arrayList.add(parameterMetadata);
                }
                n += list.size();
            }
            this.m_parameterMetadata = Collections.unmodifiableList(arrayList);
        }
        return this.m_parameterMetadata;
    }

    public ParameterInputValue getPushedParam(int n, int n2) throws SQLEngineException, OperationCanceledException, IllegalStateException {
        ParameterInputValue[] parameterInputValueArray = this.getPushedParameter().get(n);
        if (null == parameterInputValueArray) {
            throw new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.INVALID_PARAM_SET.name(), new String[]{String.valueOf(n)});
        }
        if (1 > n2 || n2 > parameterInputValueArray.length) {
            throw new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.INVALID_PARAM_NUMBER.name(), new String[]{String.valueOf(n2)});
        }
        ParameterInputValue parameterInputValue = parameterInputValueArray[n2];
        assert (null != parameterInputValue);
        return parameterInputValue;
    }

    @Override
    public int getNumParams() throws ErrorException {
        return this.getMetadataForParameters().size();
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        return this.m_results;
    }

    protected IAEStatement doPassdownOptimize(IAEStatement iAEStatement) throws ErrorException {
        new AEPassdownOpOptimizer(this.m_opHandlerFactory).optimize(iAEStatement);
        return iAEStatement;
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) throws ErrorException {
        Iterator<IAEStatement> iterator = this.m_aeStatements.getStatementItr();
        int n = 0;
        while (iterator.hasNext()) {
            IAEStatement iAEStatement = iterator.next();
            for (AEParameter aEParameter : iAEStatement.getDynamicParameters()) {
                IColumn iColumn = aEParameter.getInferredOrSetColumn();
                TypeMetadata typeMetadata = map.get(n);
                if (typeMetadata == null && (typeMetadata = iColumn.getTypeMetadata()).getType() == 0) {
                    typeMetadata = TypeMetadata.createTypeMetadata(1);
                    typeMetadata.setLength(Long.MAX_VALUE);
                }
                ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata);
                columnMetadata.setName(iColumn.getName());
                if (typeMetadata.isCharacterOrBinaryType()) {
                    typeMetadata.setLength(Long.MAX_VALUE);
                }
                aEParameter.setColumn(columnMetadata);
                ++n;
            }
        }
        if (n > 0) {
            this.m_aeStatements.reprocessMetadata();
            this.m_parameterMetadata = null;
        }
    }

    private Map<Integer, Map<Integer, ArrayList<ParameterInputValue>>> getUnprocessedPushedValues() throws OperationCanceledException {
        if (this.m_context.isCanceled()) {
            throw SQLEngineExceptionFactory.operationCanceledException();
        }
        return this.m_unprocessedPushedValues;
    }

    private Map<Integer, ParameterInputValue[]> getPushedParameter() throws OperationCanceledException, IllegalStateException {
        if (this.m_context.isCanceled()) {
            throw SQLEngineExceptionFactory.operationCanceledException();
        }
        if (this.m_pushedValues == null) {
            throw new IllegalStateException("Request for pushed parameter data before finalizePushedParamData() has been called.");
        }
        return this.m_pushedValues;
    }

    private static ExecutionResults createMetadataResults(AEStatements aEStatements) throws ErrorException {
        if (aEStatements.size() == 0) {
            throw new InvalidArgumentException(7, "statements");
        }
        ExecutionResults executionResults = new ExecutionResults();
        Iterator<IAEStatement> iterator = aEStatements.getStatementItr();
        while (iterator.hasNext()) {
            ExecutionResult executionResult;
            IAEStatement iAEStatement = iterator.next();
            if (iAEStatement instanceof AEQuery) {
                executionResult = SqlQueryExecutor.createMetadataResult((AEQuery)iAEStatement);
                executionResults.addExecutionResult(executionResult);
                continue;
            }
            if (iAEStatement instanceof AERowCountStatement) {
                executionResult = SqlQueryExecutor.createMetadataResult((AERowCountStatement)iAEStatement);
                executionResults.addExecutionResult(executionResult);
                continue;
            }
            if (iAEStatement instanceof AEProcedureCall) {
                executionResult = SqlQueryExecutor.createMetadataResult((AEProcedureCall)iAEStatement);
                executionResults.addExecutionResult(executionResult);
                continue;
            }
            throw SQLEngineExceptionFactory.invalidAETreeException();
        }
        return executionResults;
    }

    private static ExecutionResult createMetadataResult(AEQuery aEQuery) {
        return new ExecutionResult(new DSIMetadataOnlyResultSet(aEQuery.createResultSetColumns()));
    }

    private static ExecutionResult createMetadataResult(AERowCountStatement aERowCountStatement) {
        return new ExecutionResult(new DSISimpleRowCountResult(0L));
    }

    private static ExecutionResult createMetadataResult(AEProcedureCall aEProcedureCall) throws ErrorException {
        List<? extends IColumn> list = aEProcedureCall.getOperand().getProcedure().getCurrentResultMetadata();
        if (list.isEmpty()) {
            return new ExecutionResult(new DSISimpleRowCountResult(-1L));
        }
        return new ExecutionResult(new DSIMetadataOnlyResultSet(list));
    }
}

