/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.jdbc;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc.common.CommonUtils;
import com.databricks.client.jdbc.common.ProxySettings;
import com.databricks.client.jdbc.rpc.HttpClientFactory;
import com.databricks.client.jdbc42.internal.apache.http.HttpResponse;
import com.databricks.client.jdbc42.internal.apache.http.HttpVersion;
import com.databricks.client.jdbc42.internal.apache.http.client.config.RequestConfig;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpDelete;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpGet;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpPut;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpUriRequest;
import com.databricks.client.jdbc42.internal.apache.http.entity.FileEntity;
import com.databricks.client.jdbc42.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.CloseableHttpClient;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.HttpClientBuilder;
import com.databricks.client.jdbc42.internal.apache.http.message.BasicStatusLine;
import com.databricks.client.jdbc42.internal.apache.http.protocol.HttpContext;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.core.JsonProcessingException;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.ObjectReader;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;

public class UCVolumeIngestionManager {
    private static final String RETRY_AFTER_HEADER = "Retry-After";
    public static final int STAGING_OPERAION_METHOD_INDEX = 0;
    private static final int STAGING_URL_INDEX = 1;
    private static final int STAGING_OPERAION_HEADERS_INDEX = 2;
    public static final int STAGING_OPERAION_LOCAL_PATH_INDEX = 3;
    private static final String STAGING_OPERAION_GET = "GET";
    private static final String STAGING_OPERAION_PUT = "PUT";
    private static final String STAGING_OPERAION_REMOVE = "REMOVE";
    private CloseableHttpClient m_httpClient;
    private ILogger m_logger;
    private HiveJDBCSettings m_settings;
    private int m_retryAfterTime = 30;
    private static final int SECONDS = 60;
    private static final int MILLISECONDS = 1000;

    public UCVolumeIngestionManager(ILogger iLogger, HiveJDBCSettings hiveJDBCSettings) {
        this.m_logger = iLogger;
        this.m_settings = hiveJDBCSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performOperations(List<String> list) throws ErrorException {
        block17: {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            try {
                Object object;
                String string = list.get(0);
                String string2 = list.get(1);
                String string3 = list.get(2);
                String string4 = "{}";
                Map map = null;
                if (string3.equalsIgnoreCase(string4)) {
                    LogUtilities.logWarning("No HTTP header found for UC volume ingestion operation. ", this.m_logger);
                } else {
                    object = new ObjectMapper().readerFor(Map.class);
                    try {
                        map = (Map)((ObjectReader)object).readValue(string3);
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HEADERS_PARSING_ERROR_UC_INGESTION.name(), jsonProcessingException.getMessage());
                        throw errorException;
                    }
                }
                object = this.m_settings.m_stagingAllowedLocalPaths;
                if (string.equalsIgnoreCase(STAGING_OPERAION_GET) || string.equalsIgnoreCase(STAGING_OPERAION_PUT)) {
                    Path path = Paths.get(list.get(3), new String[0]).toAbsolutePath().normalize();
                    String string5 = path.getParent().toString();
                    boolean bl = false;
                    Object object2 = object.iterator();
                    while (object2.hasNext()) {
                        String string6 = (String)object2.next();
                        Path path2 = Paths.get(string6, new String[0]).toAbsolutePath().normalize();
                        if (!string5.equalsIgnoreCase(path2.toString())) continue;
                        bl = true;
                        break;
                    }
                    if (bl && string.equalsIgnoreCase(STAGING_OPERAION_GET)) {
                        this.processGetRequest(string2, map, path.toString());
                        break block17;
                    }
                    if (bl && string.equalsIgnoreCase(STAGING_OPERAION_PUT)) {
                        this.processPutRequest(string2, map, path.toString());
                        break block17;
                    }
                    object2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.LOCAL_FILE_PATH_OUTSIDE_STAGING_ALLOWED_PATHS_UC_INGESTION.name());
                    throw object2;
                }
                if (string.equalsIgnoreCase(STAGING_OPERAION_REMOVE)) {
                    this.processRemoveRequest(string2, map);
                    break block17;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GENERAL_ERROR_UC_INGESTION.name(), "following staging query operation is not supported. " + string);
                throw errorException;
            }
            finally {
                try {
                    if (this.m_httpClient != null) {
                        this.m_httpClient.close();
                    }
                }
                catch (IOException iOException) {
                    LogUtilities.logWarning("Got an error  while closing the httpClient object. ", this.m_logger);
                }
            }
        }
    }

    private void processGetRequest(String string, Map<String, String> map, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HttpGet httpGet = new HttpGet(string);
        HttpResponse httpResponse = null;
        if (map != null) {
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                httpGet.addHeader(object2.getKey(), object2.getValue());
            }
            LogUtilities.logDebug(" Number of HTTP headers added to the GET request are" + httpGet.getAllHeaders().length, this.m_logger);
        }
        try {
            httpResponse = this.executeReqWithRetry(httpGet);
            int n = httpResponse.getStatusLine().getStatusCode();
            if (httpResponse != null && n == 200 || n == 201 || n == 202 || n == 204) {
                int n2;
                InputStream inputStream = httpResponse.getEntity().getContent();
                FileOutputStream fileOutputStream = new FileOutputStream(new File(string2));
                byte[] byArray = new byte[4096];
                while ((n2 = inputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n2);
                }
                LogUtilities.logDebug(" Download complete!!", this.m_logger);
            } else {
                if (this.m_settings.m_enableUCIngestionHTTPErrorTesting.booleanValue() && n == 500) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GENERAL_ERROR_UC_INGESTION.name(), "This HTTP request did not complete successfully.");
                    throw errorException;
                }
                LogUtilities.logWarning("This HTTP request did not complete successfully. ", this.m_logger);
            }
        }
        catch (IOException iOException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.LOCAL_FILE_WRITE_ERROR_UC_INGESTION.name(), iOException.getMessage());
            throw errorException;
        }
    }

    private void processPutRequest(String string, Map<String, String> map, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HttpPut httpPut = new HttpPut(string);
        HttpResponse httpResponse = null;
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpPut.addHeader(entry.getKey(), entry.getValue());
            }
            LogUtilities.logDebug(" Number of HTTP headers added to the PUT request are" + httpPut.getAllHeaders().length, this.m_logger);
        }
        FileEntity fileEntity = new FileEntity(new File(string2));
        fileEntity.setContentType("binary/octet-stream");
        httpPut.setEntity(fileEntity);
        httpResponse = this.executeReqWithRetry(httpPut);
        int n = httpResponse.getStatusLine().getStatusCode();
        if (httpResponse != null && n == 200 || n == 201 || n == 202 || n == 204) {
            LogUtilities.logDebug(" The file is uploaded successfully to the server!", this.m_logger);
        } else {
            LogUtilities.logDebug(" The file is Not uploaded to the server!", this.m_logger);
        }
    }

    private void processRemoveRequest(String string, Map<String, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HttpDelete httpDelete = new HttpDelete(string);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                httpDelete.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
            LogUtilities.logDebug(" Number of HTTP headers added to the REMOVE request are" + httpDelete.getAllHeaders().length, this.m_logger);
        }
        Object object = null;
        object = this.executeReqWithRetry(httpDelete);
        int n = object.getStatusLine().getStatusCode();
        if (object != null && n == 200 || n == 201 || n == 202 || n == 204) {
            LogUtilities.logDebug(" The file is removed successfully from the server!", this.m_logger);
        } else {
            LogUtilities.logDebug(" The file is Not removed from the server!", this.m_logger);
        }
    }

    private HttpResponse executeReqWithRetry(HttpUriRequest httpUriRequest) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_httpClient == null) {
            this.createHttpClient(httpUriRequest);
        }
        int n = this.m_retryAfterTime;
        HttpResponse httpResponse = null;
        Instant instant = Instant.now();
        do {
            Object object;
            try {
                Object object2;
                if (this.m_settings.m_enableUCIngestionHTTPErrorTesting.booleanValue()) {
                    LogUtilities.logWarning("EnableUCIngestionHTTPErrorTesting is enabled. Dummy HTTP response for testing purposes.", this.m_logger);
                    object2 = new DefaultHttpResponseFactory();
                    httpResponse = object2.newHttpResponse(new BasicStatusLine(HttpVersion.HTTP_1_1, 502, null), null);
                } else {
                    LogUtilities.logDebug("Sending HTTP request to the server.", this.m_logger);
                    if (this.m_settings.m_proxySettings != null && this.m_settings.m_proxySettings.m_useProxy && this.m_settings.m_proxySettings.m_proxyAuth == ProxySettings.ProxyAuthentication.KERBEROS) {
                        object2 = HttpClientFactory.getProxyContext(this.m_settings.m_proxySettings, this.m_logger);
                        httpResponse = this.m_httpClient.execute(httpUriRequest, (HttpContext)object2);
                    } else {
                        httpResponse = this.m_httpClient.execute(httpUriRequest);
                    }
                }
            }
            catch (IOException iOException) {
                object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GENERAL_ERROR_UC_INGESTION.name(), iOException.getMessage());
                throw object;
            }
            if (httpResponse == null) continue;
            int n2 = httpResponse.getStatusLine().getStatusCode();
            LogUtilities.logWarning("Got response code " + n2, this.m_logger);
            if (n2 == 200 || n2 == 201 || n2 == 202 || n2 == 204) {
                return httpResponse;
            }
            if (this.m_settings.m_ucIngestionRetriableHttpCode.contains(String.valueOf(n2))) {
                LogUtilities.logWarning("Staging operation over HTTP was unsuccessful. Received HTTP status code " + n2 + " Retrying HTTP request.", this.m_logger);
                LogUtilities.logWarning("Retrying HTTP request. Received HTTP status code " + n2, this.m_logger);
                object = httpResponse.getFirstHeader(RETRY_AFTER_HEADER);
                try {
                    if (object == null) {
                        LogUtilities.logWarning("Got Http Retry-After header null when executing Get request for UC Volume Ingestion. ", this.m_logger);
                        LogUtilities.logWarning("Retrying HTTP request after " + n + " seconds for UC Volume Ingestion ", this.m_logger);
                        Thread.sleep(n * 1000);
                        n *= 2;
                        continue;
                    }
                    LogUtilities.logWarning("Received succesfully Http Retry-After header  when executing Get request for UC Volume Ingestion. ", this.m_logger);
                    int n3 = Integer.valueOf(object.getValue());
                    LogUtilities.logWarning("Retrying HTTP request after " + n3 + " seconds for UC Volume Ingestion ", this.m_logger);
                    Thread.sleep(n3 * 1000);
                }
                catch (InterruptedException interruptedException) {
                    LogUtilities.logWarning("Thread interrupted while waiting for http retry: " + interruptedException.getMessage(), this.m_logger);
                }
                continue;
            }
            LogUtilities.logWarning("Staging operation over HTTP was unsuccessful. Received HTTP status code " + n2, this.m_logger);
            LogUtilities.logWarning("This HTTP status code is not listed in triable HTTP code setting. This request will not be retried", this.m_logger);
            if (!this.m_settings.m_enableUCIngestionHTTPErrorTesting.booleanValue()) break;
            object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GENERAL_ERROR_UC_INGESTION.name(), "This HTTP status code is not listed in triable HTTP code setting. This request will not be retried");
            throw object;
        } while (0 == this.m_settings.m_ucIngestionRetryTimeout || this.timeLapsed(instant) <= this.m_settings.m_ucIngestionRetryTimeout);
        LogUtilities.logWarning("HTTP request retried for MAX time " + this.m_settings.m_ucIngestionRetryTimeout + " minutes.", this.m_logger);
        return httpResponse;
    }

    private int timeLapsed(Instant instant) {
        Instant instant2 = Instant.now();
        int n = (int)Duration.between(instant, instant2).toMinutes();
        LogUtilities.logWarning("Time lapsed for this http request is " + n + " minutes.", this.m_logger);
        return n;
    }

    private void createHttpClient(HttpUriRequest httpUriRequest) throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        int n = this.m_settings.m_ucIngestionRetryTimeout * 60 * 1000;
        LogUtilities.logDebug("Timeout for UCIngestion HTTP request is " + n + " minutes.", this.m_logger);
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(n).setConnectionRequestTimeout(n).setSocketTimeout(n);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (this.m_settings.m_proxySettings.m_useProxy && !CommonUtils.isHostInProxyBypassList(this.m_settings.m_proxySettings, httpUriRequest)) {
            LogUtilities.logDebug("Proxy is enabled for UCIngestion HTTP request.", this.m_logger);
            object = this.m_settings.m_proxySettings;
            HttpClientFactory.setProxySettings(httpClientBuilder, (ProxySettings)object, this.m_logger);
        }
        object = builder.build();
        this.m_httpClient = httpClientBuilder.setDefaultRequestConfig((RequestConfig)object).build();
    }
}

