/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.crypto;

import com.databricks.client.jdbc42.internal.google.crypto.tink.subtle.Ed25519Sign;
import com.databricks.client.jdbc42.internal.nimbusjose.JOSEException;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSAlgorithm;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSHeader;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSSigner;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.EdDSAProvider;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.Curve;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.OctetKeyPair;
import com.databricks.client.jdbc42.internal.nimbusjose.shaded.jcip.ThreadSafe;
import com.databricks.client.jdbc42.internal.nimbusjose.util.Base64URL;
import java.security.GeneralSecurityException;

@ThreadSafe
public class Ed25519Signer
extends EdDSAProvider
implements JWSSigner {
    private final OctetKeyPair privateKey;
    private final Ed25519Sign tinkSigner;

    public Ed25519Signer(OctetKeyPair privateKey) throws JOSEException {
        if (!Curve.Ed25519.equals(privateKey.getCurve())) {
            throw new JOSEException("Ed25519Signer only supports OctetKeyPairs with crv=Ed25519");
        }
        if (!privateKey.isPrivate()) {
            throw new JOSEException("The OctetKeyPair doesn't contain a private part");
        }
        this.privateKey = privateKey;
        try {
            this.tinkSigner = new Ed25519Sign(privateKey.getDecodedD());
        }
        catch (GeneralSecurityException e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public OctetKeyPair getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Base64URL sign(JWSHeader header, byte[] signingInput) throws JOSEException {
        byte[] jwsSignature;
        JWSAlgorithm alg = header.getAlgorithm();
        if (!JWSAlgorithm.Ed25519.equals(alg) && !JWSAlgorithm.EdDSA.equals(alg)) {
            throw new JOSEException("Ed25519Verifier requires alg=Ed25519 or alg=EdDSA in JWSHeader");
        }
        try {
            jwsSignature = this.tinkSigner.sign(signingInput);
        }
        catch (GeneralSecurityException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        return Base64URL.encode(jwsSignature);
    }
}

