/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.crypto;

import com.databricks.client.jdbc42.internal.nimbusjose.JOSEException;
import com.databricks.client.jdbc42.internal.nimbusjose.JWECryptoParts;
import com.databricks.client.jdbc42.internal.nimbusjose.JWEEncrypter;
import com.databricks.client.jdbc42.internal.nimbusjose.JWEHeader;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.AAD;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.ECDH1PU;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.ECDH1PUCryptoProvider;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.Curve;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.OctetKeyPair;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.gen.OctetKeyPairGenerator;
import com.databricks.client.jdbc42.internal.nimbusjose.shaded.jcip.ThreadSafe;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.crypto.SecretKey;

@ThreadSafe
public class ECDH1PUX25519Encrypter
extends ECDH1PUCryptoProvider
implements JWEEncrypter {
    private final OctetKeyPair publicKey;
    private final OctetKeyPair privateKey;

    public ECDH1PUX25519Encrypter(OctetKeyPair privateKey, OctetKeyPair publicKey) throws JOSEException {
        this(privateKey, publicKey, null);
    }

    public ECDH1PUX25519Encrypter(OctetKeyPair privateKey, OctetKeyPair publicKey, SecretKey contentEncryptionKey) throws JOSEException {
        super(publicKey.getCurve(), contentEncryptionKey);
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    @Override
    public Set<Curve> supportedEllipticCurves() {
        return Collections.singleton(Curve.X25519);
    }

    public OctetKeyPair getPublicKey() {
        return this.publicKey;
    }

    public OctetKeyPair getPrivateKey() {
        return this.privateKey;
    }

    @Deprecated
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        return this.encrypt(header, clearText, AAD.compute(header));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText, byte[] aad) throws JOSEException {
        OctetKeyPair ephemeralPrivateKey = new OctetKeyPairGenerator(this.getCurve()).generate();
        OctetKeyPair ephemeralPublicKey = ephemeralPrivateKey.toPublicJWK();
        JWEHeader updatedHeader = new JWEHeader.Builder(header).ephemeralPublicKey(ephemeralPublicKey).build();
        SecretKey Z = ECDH1PU.deriveSenderZ(this.privateKey, this.publicKey, ephemeralPrivateKey);
        byte[] updatedAAD = Arrays.equals(AAD.compute(header), aad) ? AAD.compute(updatedHeader) : aad;
        return this.encryptWithZ(updatedHeader, Z, clearText, updatedAAD);
    }
}

