/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.oauth;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc.common.CommonUtils;
import com.databricks.client.jdbc.common.OAuthFlow;
import com.databricks.client.jdbc.common.OAuthSettings;
import com.databricks.client.jdbc.common.ProxySettings;
import com.databricks.client.jdbc.common.SSLSettings;
import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.oauth.AuthorizationCodeOAuthProvider;
import com.databricks.client.jdbc.oauth.ClientCredentialOAuthProvider;
import com.databricks.client.jdbc.oauth.OAuthUtil;
import com.databricks.client.jdbc.oauth.RefreshTokenExpiredException;
import com.databricks.client.jdbc.oauth.TokenPassThroughOAuthProvider;
import com.databricks.client.jdbc.rpc.HttpClientFactory;
import com.databricks.client.jdbc42.internal.apache.commons.codec.binary.Base64;
import com.databricks.client.jdbc42.internal.apache.http.HttpEntity;
import com.databricks.client.jdbc42.internal.apache.http.HttpHost;
import com.databricks.client.jdbc42.internal.apache.http.HttpResponse;
import com.databricks.client.jdbc42.internal.apache.http.HttpVersion;
import com.databricks.client.jdbc42.internal.apache.http.client.config.RequestConfig;
import com.databricks.client.jdbc42.internal.apache.http.client.entity.UrlEncodedFormEntity;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpGet;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpPost;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpRequestBase;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpUriRequest;
import com.databricks.client.jdbc42.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.databricks.client.jdbc42.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.CloseableHttpClient;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.HttpClientBuilder;
import com.databricks.client.jdbc42.internal.apache.http.message.BasicNameValuePair;
import com.databricks.client.jdbc42.internal.apache.http.message.BasicStatusLine;
import com.databricks.client.jdbc42.internal.apache.http.protocol.HttpContext;
import com.databricks.client.jdbc42.internal.apache.http.util.EntityUtils;
import com.databricks.client.jdbc42.internal.apache.thrift.TException;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.JsonNode;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class OauthProvider {
    protected OAuthSettings m_oAuthSettings;
    protected ILogger m_logger;
    protected HiveJDBCSettings m_settings;
    protected HashMap<String, String> m_customOAuthHeaders;
    protected long m_accessTokenExpireVal = 0L;
    private final int m_retryAfterTimeSeconds = 30;

    public OauthProvider(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_settings = hiveJDBCSettings;
        this.m_oAuthSettings = this.m_settings.m_oAuthSettings;
        this.m_logger = iLogger;
        this.m_customOAuthHeaders = new HashMap();
        if (this.m_oAuthSettings.m_EnableOIDCDiscovery && this.m_oAuthSettings.m_OIDCDiscoveryEndpoint != null && !this.m_oAuthSettings.m_OIDCDiscoveryEndpoint.isEmpty()) {
            this.OIDCDiscoveryEndpoint();
        }
        if (this.m_oAuthSettings.m_Oauth2ConfigValueTest) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.OAUTH2_CONFIG_VALUE_TEST, new String[]{this.m_oAuthSettings.m_Oauth2AuthorizeEndpoint, this.m_oAuthSettings.m_Oauth2TokenEndpoint, this.m_oAuthSettings.m_authScope, this.m_oAuthSettings.m_authClientID});
            throw errorException;
        }
    }

    public static OauthProvider createOAuthProvider(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        switch (hiveJDBCSettings.m_oAuthSettings.m_authFlow) {
            case TOKEN_PASSTHROUGH: {
                return new TokenPassThroughOAuthProvider(hiveJDBCSettings, iLogger);
            }
            case CLIENT_CREDENTIALS: {
                return new ClientCredentialOAuthProvider(hiveJDBCSettings, iLogger);
            }
            case BROWSER: {
                return new AuthorizationCodeOAuthProvider(hiveJDBCSettings, iLogger);
            }
        }
        throw new ErrorException("08006", 105, CommonJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), new String[]{String.format("Auth_Flow %d is not valid,", new Object[]{hiveJDBCSettings.m_oAuthSettings.m_authFlow})});
    }

    public String getAccessToken() {
        return this.m_oAuthSettings.m_accessToken;
    }

    public abstract void obtainAccessToken() throws TException;

    public HashMap<String, String> getCustomOAuthHeaders() {
        return this.m_customOAuthHeaders;
    }

    protected void addCustomOAuthHeader(String string, String string2) {
        this.m_customOAuthHeaders.put(string, string2);
    }

    protected String getDetailedErrorExceptionMessage(ErrorException errorException) {
        StringBuilder stringBuilder = new StringBuilder();
        if (errorException.hasMessageParams() && errorException.getMessageParams().length > 0) {
            for (String string : errorException.getMessageParams()) {
                stringBuilder.append(string + " ");
            }
        }
        return stringBuilder.toString();
    }

    protected boolean hasValidDatabricksToken() {
        return this.m_oAuthSettings.m_accessToken != null && System.currentTimeMillis() <= this.m_oAuthSettings.m_expiryTime;
    }

    protected void decodeAndExchangeAccessToken(boolean bl) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_settings.m_oAuthSettings.m_accessToken == null) {
            return;
        }
        boolean bl2 = true;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String[] stringArray = this.m_settings.m_oAuthSettings.m_accessToken.split("\\.");
            if (stringArray.length < 2) {
                throw new TException("access token is not a well-formed JWT.");
            }
            String string = stringArray[1];
            Base64 base64 = new Base64(true);
            String string2 = new String(base64.decode(string));
            JsonNode jsonNode = objectMapper.readTree(string2);
            this.m_accessTokenExpireVal = jsonNode.get("exp").asLong();
            String string3 = jsonNode.get("iss").asText();
            string3 = string3.replaceFirst("https://", "").trim();
            String string4 = this.m_settings.m_host.trim();
            bl2 = string3.startsWith(string4);
            if (!bl || bl2) {
                return;
            }
            LogUtilities.logDebug("Access token issuer is not same as the host. exchanging access token.", this.m_logger);
            this.exchangeIDPFederationToken();
            String[] stringArray2 = this.m_settings.m_oAuthSettings.m_accessToken.split("\\.");
            if (stringArray2.length < 2) {
                throw new TException("exchanged access token is not a well-formed JWT.");
            }
            String string5 = stringArray2[1];
            Base64 base642 = new Base64(true);
            String string6 = new String(base642.decode(string5));
            JsonNode jsonNode2 = objectMapper.readTree(string6);
            this.m_accessTokenExpireVal = jsonNode2.get("exp").asLong();
        }
        catch (Exception exception) {
            LogUtilities.logError("Error in exchanging access token to dbr in-house access token.", this.m_logger);
            LogUtilities.logError(exception, this.m_logger);
            LogUtilities.logError("This Error will be ignored and driver use the original access token.", this.m_logger);
        }
    }

    private void exchangeIDPFederationToken() throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = "https://" + this.m_settings.m_host + "/oidc/oauth2/v2.0/token";
        URI uRI = OAuthUtil.getServerURI(string, this.m_oAuthSettings.m_OAuth2EnableAuthURLIPRange);
        String string2 = null;
        HttpPost httpPost = new HttpPost(uRI);
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
        arrayList.add(new BasicNameValuePair("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer"));
        arrayList.add(new BasicNameValuePair("assertion", this.m_oAuthSettings.m_accessToken));
        arrayList.add(new BasicNameValuePair("scope", "sql"));
        if (this.m_oAuthSettings.m_IdentityFederationClientId != null && !this.m_oAuthSettings.m_IdentityFederationClientId.isEmpty()) {
            arrayList.add(new BasicNameValuePair("identity_federation_client_id", this.m_oAuthSettings.m_IdentityFederationClientId));
        } else {
            arrayList.add(new BasicNameValuePair("return_original_token_if_authenticated", "true"));
        }
        try {
            httpPost.setEntity(new UrlEncodedFormEntity(arrayList, "UTF-8"));
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage(), exception.getCause().toString()});
            throw errorException;
        }
        if (this.m_oAuthSettings.m_authFlow == OAuthFlow.AZURE_Managed_Identity && this.m_oAuthSettings.m_azureResourceId != null && !this.m_oAuthSettings.m_azureResourceId.isEmpty() && this.m_customOAuthHeaders != null) {
            for (Map.Entry entry : this.m_customOAuthHeaders.entrySet()) {
                if (entry.getKey() != "X-Databricks-Azure-Workspace-Resource-Id" && entry.getKey() != "X-Databricks-Azure-SP-Management-Token") continue;
                httpPost.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        httpPost.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        if (!httpPost.getURI().getScheme().equals("https")) {
            object = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.AUTHORIZATIONN_URL_ERROR.name(), "HTTPS required");
            throw object;
        }
        string2 = this.executeRequestWithRetry(uRI, httpPost);
        if (string2 == null || string2.isEmpty()) {
            object = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.ERROR_PARSING_JSON_RESPONSE.name(), "No token response.");
            throw object;
        }
        this.parseTokenResponse(string2);
    }

    protected boolean hasValidAccessTokenJwtExpiry() {
        if (this.m_settings.m_oAuthSettings.m_accessToken == null || this.m_accessTokenExpireVal == 0L) {
            return false;
        }
        long l = System.currentTimeMillis() / 1000L - (long)this.m_settings.m_oAuthSettings.m_tokenExpiryBuffer;
        return this.m_accessTokenExpireVal > l;
    }

    protected String executeRequestWithRetry(URI uRI, HttpRequestBase httpRequestBase) throws ErrorException {
        Object object;
        Object object2;
        LogUtilities.logFunctionEntrance(this.m_logger, uRI, httpRequestBase);
        SSLSettings sSLSettings = this.m_oAuthSettings.m_tokenEndpointSSLSettings;
        HttpResponse httpResponse = null;
        String string = null;
        int n = 30;
        Instant instant = Instant.now();
        SSLConnectionSocketFactory sSLConnectionSocketFactory = CommonUtils.getSSLConnectionSocketFactory(uRI.getHost(), sSLSettings);
        int n2 = this.m_settings.m_oAuthHTTPRetryTimeout * 60 * 1000;
        LogUtilities.logDebug("Timeout for OAuth HTTP request is " + this.m_settings.m_oAuthHTTPRetryTimeout + " minutes.", this.m_logger);
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(n2).setConnectionRequestTimeout(n2).setSocketTimeout(n2).setCookieSpec("standard");
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setSSLSocketFactory(sSLConnectionSocketFactory);
        if (this.m_settings.m_proxySettings.m_useProxy && !CommonUtils.isHostInProxyBypassList(this.m_settings.m_proxySettings, httpRequestBase)) {
            LogUtilities.logDebug("Proxy is enabled for OAuth HTTP request.", this.m_logger);
            HttpClientFactory.setProxySettings(httpClientBuilder, this.m_settings.m_proxySettings, this.m_logger);
            object2 = this.m_settings.m_proxySettings;
            object = new HttpHost(((ProxySettings)object2).m_proxyHost, ((ProxySettings)object2).m_proxyPort);
            builder.setProxy((HttpHost)object);
        }
        object2 = builder.build();
        CloseableHttpClient closeableHttpClient = httpClientBuilder.setDefaultRequestConfig((RequestConfig)object2).build();
        do {
            Object object3;
            try {
                if (this.m_settings.m_enableOAuthHTTPErrorTesting) {
                    LogUtilities.logWarning("EnableOAuthHTTPErrorTesting is enabled. Dummy HTTP response for testing purposes.", this.m_logger);
                    object = new DefaultHttpResponseFactory();
                    httpResponse = object.newHttpResponse(new BasicStatusLine(HttpVersion.HTTP_1_1, 502, "Dummy HTTP response for testing purposes"), null);
                } else {
                    httpRequestBase.setConfig((RequestConfig)object2);
                    if (this.m_settings.m_proxySettings != null && this.m_settings.m_proxySettings.m_useProxy && this.m_settings.m_proxySettings.m_proxyAuth == ProxySettings.ProxyAuthentication.KERBEROS) {
                        object = HttpClientFactory.getProxyContext(this.m_settings.m_proxySettings, this.m_logger);
                        httpResponse = closeableHttpClient.execute((HttpUriRequest)httpRequestBase, (HttpContext)object);
                    } else {
                        httpResponse = closeableHttpClient.execute(httpRequestBase);
                    }
                    object = httpResponse.getEntity();
                    string = EntityUtils.toString((HttpEntity)object);
                }
            }
            catch (Exception exception) {
                object3 = exception.getCause() == null ? "" : exception.getCause().toString();
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage(), object3});
                throw errorException;
            }
            if (httpResponse == null) continue;
            int n3 = httpResponse.getStatusLine().getStatusCode();
            LogUtilities.logWarning("Got response code " + n3, this.m_logger);
            if (n3 == 200 || n3 == 201 || n3 == 202 || n3 == 204) break;
            if (this.m_settings.m_oAuthRetriableHttpCode.contains(String.valueOf(n3))) {
                LogUtilities.logWarning("OAuth HTTP request for token was unsuccessful. Received HTTP status code " + n3 + " Retrying HTTP request.", this.m_logger);
                object3 = httpResponse.getFirstHeader("Retry-After");
                try {
                    if (object3 == null) {
                        LogUtilities.logWarning("Got Http Retry-After header null when executing OAuth HTTP request for token . ", this.m_logger);
                        LogUtilities.logWarning("Retrying HTTP request after " + n + " seconds for OAuth token  ", this.m_logger);
                        Thread.sleep(n * 1000);
                        n *= 2;
                        continue;
                    }
                    LogUtilities.logWarning("Received succesfully Http Retry-After header  when executing OAuth HTTP request for token . ", this.m_logger);
                    int n4 = Integer.valueOf(object3.getValue());
                    LogUtilities.logWarning("Retrying HTTP request after " + n4 + " seconds for OAuth HTTP request for token  ", this.m_logger);
                    Thread.sleep(n4 * 1000);
                }
                catch (InterruptedException interruptedException) {
                    LogUtilities.logWarning("Thread interrupted while waiting for http retry: " + interruptedException.getMessage(), this.m_logger);
                }
                continue;
            }
            LogUtilities.logWarning("OAuth HTTP request for token was unsuccessful. Received HTTP status code " + n3, this.m_logger);
            LogUtilities.logWarning("This HTTP status code is not listed in triable HTTP code setting. This request will not be retried", this.m_logger);
            if (!this.m_settings.m_enableOAuthHTTPErrorTesting) break;
            object3 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), "This HTTP status code is not listed in triable HTTP code setting. This request will not be retried");
            throw object3;
        } while (0 == this.m_settings.m_oAuthHTTPRetryTimeout || this.timeLapsed(instant) <= this.m_settings.m_oAuthHTTPRetryTimeout);
        this.checkResponse(httpResponse, string);
        return string;
    }

    private void checkResponse(HttpResponse httpResponse, String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n != 200) {
            if (n == 400) {
                String string2 = OAuthUtil.parseJsonResponse(string, "error");
                String string3 = OAuthUtil.parseJsonResponse(string, "error_description");
                LogUtilities.logDebug("Got response code 400. Error: " + string2 + " Error Description: " + string3, this.m_logger);
                if (string3.equalsIgnoreCase("Refresh token is invalid")) {
                    RefreshTokenExpiredException refreshTokenExpiredException = new RefreshTokenExpiredException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), 0, new String[]{string2, string3});
                    throw refreshTokenExpiredException;
                }
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{string2, string3});
                throw errorException;
            }
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{Integer.toString(n), httpResponse.getStatusLine().getReasonPhrase()});
            throw errorException;
        }
    }

    private int timeLapsed(Instant instant) {
        Instant instant2 = Instant.now();
        int n = (int)Duration.between(instant, instant2).toMinutes();
        LogUtilities.logWarning("Time lapsed for this http request is " + n + " minutes.", this.m_logger);
        return n;
    }

    protected void getAccessTokenFromRefresh() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        URI uRI = OAuthUtil.getServerURI(this.m_oAuthSettings.m_Oauth2TokenEndpoint, this.m_oAuthSettings.m_OAuth2EnableAuthURLIPRange);
        String string = null;
        HttpPost httpPost = new HttpPost(uRI);
        httpPost = this.setTokenRequestParams(httpPost);
        httpPost.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        if (!httpPost.getURI().getScheme().equals("https")) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.AUTHORIZATIONN_URL_ERROR.name(), "HTTPS required");
            throw errorException;
        }
        string = this.executeRequestWithRetry(uRI, httpPost);
        if (string == null || string.isEmpty()) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.ERROR_PARSING_JSON_RESPONSE.name(), "No token response.");
            throw errorException;
        }
        this.parseTokenResponse(string);
    }

    protected void parseTokenResponse(String string) throws ErrorException {
        JsonNode jsonNode = null;
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode2 = null;
        try {
            jsonNode2 = objectMapper.readTree(string);
        }
        catch (IOException iOException) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.ERROR_PARSING_JSON_RESPONSE.name(), iOException.getMessage());
            errorException.initCause(iOException);
            throw errorException;
        }
        jsonNode = jsonNode2.get("access_token");
        if (jsonNode == null) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.ERROR_PARSING_JSON_RESPONSE.name(), "No access token found in response.");
            throw errorException;
        }
        this.m_oAuthSettings.m_accessToken = jsonNode.asText();
        jsonNode = jsonNode2.get("refresh_token");
        if (jsonNode != null) {
            this.m_oAuthSettings.m_refreshToken = jsonNode.asText();
        }
        if ((jsonNode = jsonNode2.get("expires_in")) != null) {
            int n = jsonNode.asInt();
            int n2 = n = this.m_oAuthSettings.m_tokenExpiryBuffer < n ? n - this.m_oAuthSettings.m_tokenExpiryBuffer : 0;
            if (n == 0) {
                LogUtilities.logWarning("Token expiry buffer " + String.valueOf(this.m_oAuthSettings.m_tokenExpiryBuffer) + " is greater than the token expiry time " + n + ". A new token will be requested. ", this.m_logger);
            }
            this.m_oAuthSettings.m_expiryTime = System.currentTimeMillis() + (long)(n * 1000);
        }
    }

    private HttpPost setTokenRequestParams(HttpPost httpPost) throws ErrorException {
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
        arrayList.add(new BasicNameValuePair("grant_type", "refresh_token"));
        arrayList.add(new BasicNameValuePair("refresh_token", this.m_oAuthSettings.m_refreshToken));
        arrayList.add(new BasicNameValuePair("client_id", this.m_oAuthSettings.m_authClientID));
        if (this.m_oAuthSettings.m_authClientSecret != null) {
            arrayList.add(new BasicNameValuePair("client_secret", this.m_oAuthSettings.m_authClientSecret));
        }
        try {
            httpPost.setEntity(new UrlEncodedFormEntity(arrayList, "UTF-8"));
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage(), exception.getCause().toString()});
            throw errorException;
        }
        return httpPost;
    }

    private void OIDCDiscoveryEndpoint() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = "https://" + this.m_settings.m_host + "/oidc/oauth2/v2.0/token";
        String string2 = "https://" + this.m_settings.m_host + "/oidc/oauth2/v2.0/authorize";
        boolean bl = this.m_oAuthSettings.m_Oauth2AuthorizeEndpoint.equals(string2);
        boolean bl2 = this.m_oAuthSettings.m_Oauth2TokenEndpoint.equals(string);
        if (!bl && !bl2) {
            LogUtilities.logWarning("OIDC discovery was not used since there are setting for token and authorize end points in connection string.", this.m_logger);
            return;
        }
        URI uRI = null;
        HttpGet httpGet = null;
        try {
            uRI = new URL(this.m_oAuthSettings.m_OIDCDiscoveryEndpoint).toURI();
            httpGet = new HttpGet(uRI);
        }
        catch (MalformedURLException | URISyntaxException exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.AUTHORIZATIONN_URL_ERROR.name(), "HTTPS required");
            LogUtilities.logWarning(errorException.getMessage(), this.m_logger);
            return;
        }
        String string3 = null;
        httpGet.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        try {
            string3 = this.executeRequestWithRetry(uRI, httpGet);
            String string4 = OAuthUtil.parseJsonResponse(string3.toString(), "authorization_endpoint");
            String string5 = OAuthUtil.parseJsonResponse(string3.toString(), "token_endpoint");
            String string6 = OAuthUtil.parseJsonResponse(string3.toString(), "response_types_supported");
            if (null != string4 && bl) {
                this.m_oAuthSettings.m_Oauth2AuthorizeEndpoint = string4;
            }
            if (null != string5 && bl2) {
                this.m_oAuthSettings.m_Oauth2TokenEndpoint = string5;
            }
            if (null != string6 || string6 != "code") {
                LogUtilities.logWarning("code is not a supported response type, the authentication may fail. The driver will still try it", this.m_logger);
            }
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage()});
            LogUtilities.logWarning(errorException.getMessage(), this.m_logger);
            return;
        }
    }
}

