/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.impl.future.ConversionConfig;
import com.databricks.client.dsi.core.utilities.impl.future.DateJDBCDataSink;
import com.databricks.client.dsi.dataengine.interfaces.future.ISqlDataSink;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.dsi.utilities.CalendarSetter;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.Date;
import java.util.Calendar;
import java.util.Objects;

public class DateJDBCDataSinkAdapter
extends DateJDBCDataSink {
    private final ISqlDataSink m_wrapped;

    public DateJDBCDataSinkAdapter(ISqlDataSink iSqlDataSink, IWarningListener iWarningListener, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
        this.m_wrapped = Objects.requireNonNull(iSqlDataSink);
    }

    protected final ISqlDataSink getWrapped() {
        return this.m_wrapped;
    }

    @Override
    protected void doSet(Date date, Calendar calendar) throws ErrorException {
        try {
            this.m_wrapped.set(date == null ? null : CalendarSetter.getDate(date, calendar));
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new RuntimeException("Should never happen!", incorrectTypeException);
        }
        catch (ConversionFailed conversionFailed) {
            throw new RuntimeException("Should never happen!", conversionFailed);
        }
    }
}

