/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.databricks.client.dsi.core.utilities.impl.future.ConversionConfig;
import com.databricks.client.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class BitBooleanJDBCDataSink
extends ConvertingJDBCDataSink {
    public BitBooleanJDBCDataSink(IWarningListener iWarningListener, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
    }

    protected final void handleConversionResult(Object object, String string) throws ConversionFailed {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(object, 0, string);
                break;
            }
            case OVERFLOW: {
                this.onOverflow(object, string);
            }
        }
    }

    protected final void setBooleanFromDouble(double d, String string) throws ConversionFailed, ErrorException {
        boolean bl = NonTrivialJDBCConversions.doubleToBoolean(d, this.getAndClearListener());
        this.handleConversionResult(d, string);
        this.doSet(bl);
    }

    protected abstract void doSet(Boolean var1) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null || object instanceof Boolean) {
            this.doSet((Boolean)object);
        } else if (object instanceof Number) {
            this.doSet(((Number)object).doubleValue() != 0.0);
        } else {
            throw new IncorrectTypeException();
        }
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 2000: {
                this.doSet(null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setBoolean(boolean bl) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.doSet(bl);
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setBooleanFromDouble(by, "setByte");
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setBooleanFromDouble(s, "setShort");
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setBooleanFromDouble(n, "setInt");
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setBooleanFromDouble(l, "setLong");
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setBooleanFromDouble(f, "setFloat");
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setBooleanFromDouble(d, "setDouble");
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            this.setBooleanFromDouble(bigDecimal.doubleValue(), "setBigDecimal");
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            boolean bl = NonTrivialJDBCConversions.stringToBooleanStrict(string, this.getAndClearListener());
            this.handleConversionResult(string, "setString");
            this.setBoolean(bl);
        }
    }
}

