/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.impl;

import com.databricks.client.dsi.core.impl.DSIDriver;
import com.databricks.client.dsi.core.interfaces.IConnection;
import com.databricks.client.dsi.core.interfaces.IDriver;
import com.databricks.client.dsi.core.interfaces.IEnvironment;
import com.databricks.client.dsi.core.utilities.AttributeDataMap;
import com.databricks.client.dsi.core.utilities.Variant;
import com.databricks.client.dsi.exceptions.BadPropertyKeyException;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.dsi.exceptions.NumericOverflowException;
import com.databricks.client.dsi.exceptions.OptionalFeatureNotImplementedException;
import com.databricks.client.dsi.utilities.DSIMessageKey;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.IMessageSource;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import com.databricks.client.support.exceptions.ExceptionType;
import com.databricks.client.support.security.ICredentials;
import javax.naming.OperationNotSupportedException;

public abstract class DSIEnvironment
implements IEnvironment {
    private final AttributeDataMap m_settings = new AttributeDataMap();
    private IDriver m_parentDriver = null;
    private IWarningListener m_warningListener = null;

    public DSIEnvironment(IDriver iDriver) throws ErrorException {
        this.m_parentDriver = iDriver;
        LogUtilities.logFunctionEntrance(this.getLog(), iDriver);
        try {
            this.loadProperties();
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.DEFAULT);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.DEFAULT);
        }
    }

    @Override
    public IConnection createConnection(ICredentials iCredentials) throws ErrorException, OperationNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLog(), iCredentials);
        throw new OperationNotSupportedException();
    }

    @Override
    public IMessageSource getMessageSource() {
        return this.m_parentDriver.getMessageSource();
    }

    public AttributeDataMap getAllProperties() {
        return this.m_settings;
    }

    @Override
    public Variant getProperty(int n) throws BadPropertyKeyException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n);
        if (this.m_settings.isProperty(n)) {
            return this.m_settings.getProperty(n);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(n));
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    @Override
    public void setProperty(int n, Variant variant) throws OptionalFeatureNotImplementedException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n, variant);
        if (1 == n && variant.getType() == 6) {
            try {
                if (variant.getLong() == 0L) {
                    throw new OptionalFeatureNotImplementedException(2, DSIMessageKey.OPTIONAL_FEAT_NOT_IMPL.name(), String.valueOf(n));
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.DEFAULT);
            }
            catch (NumericOverflowException numericOverflowException) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.DEFAULT);
            }
        }
        this.m_settings.setProperty(n, variant);
    }

    public ILogger getLog() {
        return this.m_parentDriver.getDriverLog();
    }

    public IDriver getParentDriver() {
        return this.m_parentDriver;
    }

    @Override
    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    private void loadProperties() throws IncorrectTypeException, NumericOverflowException {
        this.m_settings.setProperty(1, 3, 1L);
        this.m_settings.setProperty(2, 2, Character.valueOf('\u0000'));
        this.m_settings.setProperty(3, 6, 3);
        this.m_settings.setProperty(4, 6, 1);
        this.m_settings.setProperty(5, 0, "");
        this.m_settings.setProperty(6, 0, "");
        this.m_settings.setProperty(7, 6, 42);
    }
}

