/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.vector;

import com.databricks.client.jdbc42.internal.apache.arrow.memory.ArrowBuf;
import com.databricks.client.jdbc42.internal.apache.arrow.memory.BufferAllocator;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.BaseFixedWidthVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.BitVectorHelper;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.NullCheckingForGet;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.ValueIterableVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.ValueVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.TimeMicroReaderImpl;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.reader.FieldReader;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableTimeMicroHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.TimeMicroHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.Types;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.Field;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.FieldType;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.util.TransferPair;

public final class TimeMicroVector
extends BaseFixedWidthVector
implements ValueIterableVector<Long> {
    public static final byte TYPE_WIDTH = 8;

    public TimeMicroVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.TIMEMICRO.getType()), allocator);
    }

    public TimeMicroVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public TimeMicroVector(Field field, BufferAllocator allocator) {
        super(field, allocator, 8);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new TimeMicroReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMEMICRO;
    }

    public long get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getLong((long)index * 8L);
    }

    public void get(int index, NullableTimeMicroHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getLong((long)index * 8L);
    }

    @Override
    public Long getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getLong((long)index * 8L);
    }

    private void setValue(int index, long value) {
        this.valueBuffer.setLong((long)index * 8L, value);
    }

    public void set(int index, long value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableTimeMicroHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, TimeMicroHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, long value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableTimeMicroHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TimeMicroHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, long value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, long value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static long get(ArrowBuf buffer, int index) {
        return buffer.getLong((long)index * 8L);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((TimeMicroVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        TimeMicroVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new TimeMicroVector(ref, TimeMicroVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new TimeMicroVector(field, allocator);
        }

        public TransferImpl(TimeMicroVector to) {
            this.to = to;
        }

        @Override
        public TimeMicroVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            TimeMicroVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            TimeMicroVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, TimeMicroVector.this);
        }
    }
}

