/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.rest.interceptor;

import com.darksci.pardot.api.rest.interceptor.RequestInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChainedRequestInterceptor
implements RequestInterceptor {
    private final List<RequestInterceptor> requestInterceptors;

    public ChainedRequestInterceptor(List<RequestInterceptor> requestInterceptors) {
        Objects.requireNonNull(requestInterceptors);
        this.requestInterceptors = Collections.unmodifiableList(new ArrayList<RequestInterceptor>(requestInterceptors));
    }

    @Override
    public void modifyRequestParameters(Map<String, String> requestParameters) {
        this.requestInterceptors.forEach(requestInterceptor -> requestInterceptor.modifyRequestParameters(requestParameters));
    }

    @Override
    public void modifyHeaders(Map<String, String> requestHeaders) {
        this.requestInterceptors.forEach(requestInterceptor -> requestInterceptor.modifyHeaders(requestHeaders));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private List<RequestInterceptor> requestInterceptors = new ArrayList<RequestInterceptor>();

        private Builder() {
        }

        public Builder withRequestInterceptors(List<RequestInterceptor> requestInterceptors) {
            Objects.requireNonNull(requestInterceptors);
            this.requestInterceptors.addAll(requestInterceptors);
            return this;
        }

        public Builder withRequestInterceptor(RequestInterceptor requestInterceptor) {
            Objects.requireNonNull(requestInterceptor);
            this.requestInterceptors.add(requestInterceptor);
            return this;
        }

        public ChainedRequestInterceptor build() {
            return new ChainedRequestInterceptor(this.requestInterceptors);
        }
    }
}

