/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.rest;

import com.darksci.pardot.api.ConnectionFailedException;
import com.darksci.pardot.api.config.Configuration;
import com.darksci.pardot.api.request.Request;
import com.darksci.pardot.api.rest.NoopTrustManager;
import com.darksci.pardot.api.rest.RestClient;
import com.darksci.pardot.api.rest.RestException;
import com.darksci.pardot.api.rest.RestResponse;
import com.darksci.pardot.api.rest.handlers.RestResponseHandler;
import com.darksci.pardot.api.rest.interceptor.RequestInterceptor;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRestClient
implements RestClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientRestClient.class);
    private Configuration configuration;
    private CloseableHttpClient httpClient;
    private RequestInterceptor requestInterceptor;

    @Override
    public void init(Configuration configuration) {
        HostnameVerifier hostnameVerifier;
        this.configuration = configuration;
        this.requestInterceptor = configuration.getRequestInterceptor();
        SSLContext sslcontext = SSLContexts.createDefault();
        try {
            sslcontext.init(new KeyManager[0], this.getTrustManagers(), new SecureRandom());
        }
        catch (KeyManagementException exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        if (configuration.isIgnoreInvalidSslCertificates()) {
            logger.warn("Using insecure configuration, skipping server-side certificate validation checks.");
            hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        } else {
            hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1.1", "TLSv1.2"}, null, hostnameVerifier);
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        clientBuilder.setConnectionTimeToLive(130L, TimeUnit.SECONDS).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (configuration.hasProxyConfigured()) {
            HttpHost proxyHost = new HttpHost(configuration.getProxyConfiguration().getHost(), configuration.getProxyConfiguration().getPort(), configuration.getProxyConfiguration().getScheme());
            if (configuration.getProxyConfiguration().isAuthenticationRequired()) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(configuration.getProxyConfiguration().getHost(), configuration.getProxyConfiguration().getPort()), (Credentials)new UsernamePasswordCredentials(configuration.getProxyConfiguration().getUsername(), configuration.getProxyConfiguration().getPassword()));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            requestConfigBuilder.setProxy(proxyHost);
        }
        clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        this.httpClient = clientBuilder.build();
    }

    private TrustManager[] getTrustManagers() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (this.configuration.isIgnoreInvalidSslCertificates()) {
                return new TrustManager[]{new NoopTrustManager()};
            }
            trustManagerFactory.init((KeyStore)null);
            return trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.error("Error closing: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.httpClient = null;
    }

    @Override
    public RestResponse submitRequest(Request request) throws RestException {
        try {
            return this.submitRequest(request, new RestResponseHandler());
        }
        catch (IOException exception) {
            throw new RestException(exception.getMessage(), exception);
        }
    }

    private <T> T submitRequest(Request request, ResponseHandler<T> responseHandler) throws IOException {
        String url = this.constructApiUrl(request);
        return this.submitRequest(url, request.getRequestParameters(), responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T submitRequest(String url, Map<String, String> postParams, ResponseHandler<T> responseHandler) throws IOException {
        try {
            HttpPost post = new HttpPost(url);
            this.requestInterceptor.modifyRequestParameters(postParams);
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            Arrays.stream(this.configuration.getSessionRefreshHandler().getAuthorizationHeaders()).forEach(authHeader -> post.addHeader(authHeader.getName(), authHeader.getValue()));
            Arrays.stream(this.configuration.getSessionRefreshHandler().getAuthorizationRequestParameters()).forEach(authParam -> params.add((NameValuePair)new BasicNameValuePair(authParam.getName(), authParam.getValue())));
            for (Map.Entry<String, String> entry : postParams.entrySet()) {
                params.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
            HashMap<String, String> headers = new HashMap<String, String>();
            this.requestInterceptor.modifyHeaders(headers);
            headers.forEach((arg_0, arg_1) -> ((HttpPost)post).addHeader(arg_0, arg_1));
            logger.info("Executing request {} with {}", (Object)post.getRequestLine(), this.filterSensitiveParams(params));
            Object object = this.httpClient.execute((HttpUriRequest)post, responseHandler);
            return (T)object;
        }
        catch (ClientProtocolException exception) {
            logger.error("Caught ClientProtocolException: {}", (Object)exception.getMessage(), (Object)exception);
            return null;
        }
        catch (ConnectException connectException) {
            throw new ConnectionFailedException(connectException.getMessage(), connectException);
        }
        catch (IOException exception) {
            logger.error("Caught IOException: {}", (Object)exception.getMessage(), (Object)exception);
            return null;
        }
    }

    private String constructApiUrl(Request request) {
        if (request.getApiHostname() == null) {
            return this.configuration.getPardotApiHost() + "/" + request.getApiEndpoint() + "/version/" + this.configuration.getPardotApiVersion();
        }
        return request.getApiHostname() + request.getApiEndpoint();
    }

    private List<NameValuePair> filterSensitiveParams(List<NameValuePair> inputParams) {
        String[] sensitiveFields = new String[]{"user_key", "password", "api_key", "client_secret"};
        ArrayList<NameValuePair> copiedList = new ArrayList<NameValuePair>();
        copiedList.addAll(inputParams);
        for (String sensitiveField : sensitiveFields) {
            if (!copiedList.removeIf(nameValuePair -> nameValuePair.getName().equals(sensitiveField))) continue;
            copiedList.add((NameValuePair)new BasicNameValuePair(sensitiveField, "XXXXXXX"));
        }
        return copiedList;
    }
}

