/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.response.customfield;

import com.darksci.pardot.api.parser.prospect.ProspectCustomFieldDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@JsonDeserialize(using=ProspectCustomFieldDeserializer.class)
public class ProspectCustomFieldValue {
    private final String fieldName;
    private final List<String> values = new ArrayList<String>();

    public ProspectCustomFieldValue(String fieldName, String value) {
        this.fieldName = fieldName;
        if (value != null) {
            this.values.add(value);
        }
    }

    public ProspectCustomFieldValue(String fieldName, Collection<String> values) {
        this.fieldName = fieldName;
        if (values != null) {
            this.values.addAll(values);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean hasMultipleValues() {
        return this.getValues().size() > 1;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public void addValues(Collection<String> values) {
        values.addAll(values);
    }

    public void setValue(String value) {
        this.values.clear();
        this.addValue(value);
    }

    public void setValues(Collection<String> values) {
        values.clear();
        this.addValues(values);
    }

    public String toString() {
        return "ProspectCustomFieldValue{fieldName='" + this.fieldName + '\'' + ", values=" + this.values + '}';
    }
}

