/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.response.customfield;

public enum CustomFieldType {
    UNKNOWN(0, "UNKNOWN"),
    TEXT(1, "Text"),
    RADIO_BUTTON(2, "Radio Button"),
    CHECKBOX(3, "Checkbox"),
    DROPDOWN(4, "Dropdown"),
    TEXTAREA(5, "Text Area"),
    MULTI_SELECT(6, "Multi-Select"),
    HIDDEN(7, "Hidden"),
    NUMBER(8, "Number"),
    EMAIL(9, "Email"),
    EMAIL_VALID_MX(10, "Email with valid MX record"),
    EMAIL_NON_FREE(11, "Email from non-free provider"),
    DATE(12, "Date"),
    RELATIONAL(13, "Relational"),
    CRM_USER(14, "CRM User");

    private final int value;
    private final String name;

    private CustomFieldType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public static CustomFieldType fromValue(Integer value) {
        if (value == null) {
            return UNKNOWN;
        }
        switch (value) {
            case 1: {
                return TEXT;
            }
            case 2: {
                return RADIO_BUTTON;
            }
            case 3: {
                return CHECKBOX;
            }
            case 4: {
                return DROPDOWN;
            }
            case 5: {
                return TEXTAREA;
            }
            case 6: {
                return MULTI_SELECT;
            }
            case 7: {
                return HIDDEN;
            }
            case 8: {
                return NUMBER;
            }
            case 9: {
                return EMAIL;
            }
            case 10: {
                return EMAIL_VALID_MX;
            }
            case 11: {
                return EMAIL_NON_FREE;
            }
            case 12: {
                return DATE;
            }
            case 13: {
                return RELATIONAL;
            }
            case 14: {
                return CRM_USER;
            }
        }
        return UNKNOWN;
    }
}

