/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.response;

import com.darksci.pardot.api.InvalidRequestException;
import com.darksci.pardot.api.response.ErrorResponse;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Result<T> {
    private final T value;
    private final ErrorResponse errorResponse;

    private Result(T response, ErrorResponse errorResponse) {
        if (response != null && errorResponse != null) {
            throw new IllegalArgumentException("You may not pass both parameters as non-null");
        }
        if (response == null && errorResponse == null) {
            throw new IllegalArgumentException("You may not pass both parameters as null");
        }
        this.value = response;
        this.errorResponse = errorResponse;
    }

    public static <T> Result<T> newSuccess(T response) {
        return new Result<T>(Objects.requireNonNull(response), null);
    }

    public static <T> Result<T> newFailure(ErrorResponse errorResponse) {
        return new Result<Object>(null, Objects.requireNonNull(errorResponse));
    }

    public T get() {
        if (!this.isSuccess()) {
            throw new NoSuchElementException("Cannot access response as there was an error");
        }
        return this.value;
    }

    public ErrorResponse getFailure() {
        if (this.isSuccess()) {
            throw new NoSuchElementException("Cannot access response as there was an error");
        }
        return this.errorResponse;
    }

    public boolean isSuccess() {
        return this.value != null;
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public T getOrDefault(T defaultValue) {
        if (this.isSuccess()) {
            return this.get();
        }
        return defaultValue;
    }

    public T handle(Function<? super T, T> successConsumer, Function<ErrorResponse, T> errorResponseConsumer) {
        if (this.isSuccess()) {
            return successConsumer.apply(this.value);
        }
        return errorResponseConsumer.apply(this.errorResponse);
    }

    public T handleError(Function<ErrorResponse, T> errorResponseConsumer) {
        if (this.isSuccess()) {
            return this.value;
        }
        return errorResponseConsumer.apply(this.errorResponse);
    }

    public void ifSuccess(Consumer<? super T> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this.value);
        }
    }

    public void ifError(Consumer<? super ErrorResponse> consumer) {
        if (this.isFailure()) {
            consumer.accept(this.getFailure());
        }
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public <X extends InvalidRequestException> T orElseThrowInvalidRequestException() throws X {
        return this.orElseThrow(() -> new InvalidRequestException(this.errorResponse.getMessage(), this.errorResponse.getCode()));
    }
}

