/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.request.user;

import com.darksci.pardot.api.request.BaseRequest;
import com.darksci.pardot.api.response.user.NewUser;
import org.joda.time.DateTimeZone;

public class UserCreateRequest
extends BaseRequest<UserCreateRequest> {
    @Override
    public String getApiEndpoint() {
        return "user/do/create";
    }

    public UserCreateRequest withUser(NewUser user) {
        this.withEmail(user.getEmail()).withFirstName(user.getFirstName()).withLastName(user.getLastName()).withJobTitle(user.getJobTitle()).withPhone(user.getPhone()).withUrl(user.getUrl()).withPasswordExpireable(user.isPasswordExpirable());
        if (user.getRoleId() != null) {
            this.withRole(user.getRoleId());
        } else if (user.getRole() != null) {
            this.withRole(user.getRole());
        }
        if (user.getTimezone() != null) {
            this.withTimezone(user.getTimezone());
        }
        if (user.getCrmUsername() != null && user.getCrmUsername().trim().length() > 0) {
            this.withCrmUsername(user.getCrmUsername());
        }
        return this;
    }

    public UserCreateRequest withEmail(String email) {
        return (UserCreateRequest)this.setParam("email", email);
    }

    public UserCreateRequest withUsername(String email) {
        return this.withEmail(email);
    }

    public UserCreateRequest withFirstName(String firstName) {
        return (UserCreateRequest)this.setParam("first_name", firstName);
    }

    public UserCreateRequest withLastName(String lastName) {
        return (UserCreateRequest)this.setParam("last_name", lastName);
    }

    public UserCreateRequest withJobTitle(String jobTitle) {
        return (UserCreateRequest)this.setParam("job_title", jobTitle);
    }

    public UserCreateRequest withRoleId(Long roleId) {
        return this.withRole(roleId);
    }

    public UserCreateRequest withRole(String roleName) {
        if (roleName != null) {
            this.setParam("role_id", null);
        }
        return (UserCreateRequest)this.setParam("role_name", roleName);
    }

    public UserCreateRequest withRole(Long roleId) {
        if (roleId != null) {
            this.setParam("role_name", null);
        }
        return (UserCreateRequest)this.setParam("role_id", roleId);
    }

    public UserCreateRequest withPhone(String phone) {
        return (UserCreateRequest)this.setParam("phone", phone);
    }

    public UserCreateRequest withUrl(String url) {
        return (UserCreateRequest)this.setParam("url", url);
    }

    public UserCreateRequest withPasswordExpireable(Boolean isExpirable) {
        return (UserCreateRequest)this.setBooleanParam("is_password_expirable", isExpirable);
    }

    public UserCreateRequest withTimezone(String timezoneString) {
        return (UserCreateRequest)this.setParam("timezone", timezoneString);
    }

    public UserCreateRequest withTimezone(DateTimeZone dateTimeZone) {
        return this.withTimezone(dateTimeZone.getID());
    }

    public UserCreateRequest withCrmUsername(String crmUsername) {
        return (UserCreateRequest)this.setParam("crm_username", crmUsername);
    }

    public UserCreateRequest withSendActivationEmail(boolean sendEmail) {
        return (UserCreateRequest)this.setBooleanParam("send_activation", sendEmail);
    }
}

