/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.request.prospect;

import com.darksci.pardot.api.request.BaseRequest;
import com.darksci.pardot.api.response.customfield.ProspectCustomFieldValue;
import com.darksci.pardot.api.response.prospect.Prospect;

abstract class ProspectModifyRequest<T>
extends BaseRequest<T> {
    ProspectModifyRequest() {
    }

    public T withProspect(Prospect prospect) {
        this.setParam("id", prospect.getId());
        this.setParam("email", prospect.getEmail());
        this.setParam("first_name", prospect.getFirstName());
        this.setParam("last_name", prospect.getLastName());
        this.setParam("campaign_id", prospect.getCampaignId());
        this.setParam("salutation", prospect.getSalutation());
        this.setParam("company", prospect.getCompany());
        this.setParam("prospect_account_d", prospect.getProspectAccountId());
        this.setParam("website", prospect.getWebsite());
        this.setParam("job_title", prospect.getJobTitle());
        this.setParam("department", prospect.getDepartment());
        this.setParam("country", prospect.getCountry());
        this.setParam("address_one", prospect.getAddressOne());
        this.setParam("address_two", prospect.getAddressTwo());
        this.setParam("city", prospect.getCity());
        this.setParam("state", prospect.getState());
        this.setParam("territory", prospect.getTerritory());
        this.setParam("zip", prospect.getZip());
        this.setParam("phone", prospect.getPhone());
        this.setParam("fax", prospect.getFax());
        this.setParam("source", prospect.getSource());
        this.setParam("annual_revenue", prospect.getAnnualRevenue());
        this.setParam("employees", prospect.getEmployees());
        this.setParam("industry", prospect.getIndustry());
        this.setParam("years_in_business", prospect.getYearsInBusiness());
        if (prospect.getCustomFields() != null) {
            for (ProspectCustomFieldValue customFieldValue : prospect.getCustomFields().values()) {
                if (!customFieldValue.hasMultipleValues()) {
                    this.setParam(customFieldValue.getFieldName(), customFieldValue.getValue());
                    continue;
                }
                int fieldIndex = 0;
                for (String value : customFieldValue.getValues()) {
                    this.setParam(customFieldValue.getFieldName() + "_" + fieldIndex, value);
                    ++fieldIndex;
                }
            }
        }
        return (T)this;
    }

    public T withFieldValueCleared(String fieldName) {
        return (T)this.setParam(fieldName, "");
    }

    public T withFieldValue(String fieldName, Object value) {
        return (T)this.setParam(fieldName, value);
    }

    public T withSubscribeToList(Long listId) {
        return (T)this.setParam("list_" + String.valueOf(listId), "1");
    }

    public T withUnsubscribeFromList(Long listId) {
        return (T)this.setParam("list_" + String.valueOf(listId), "0");
    }

    public T withProfileCriteriaMatching(Long profileCriteriaId) {
        return (T)this.setParam("profile_criteria_" + String.valueOf(profileCriteriaId), "match");
    }

    public T withProfileCriteriaNotMatching(Long profileCriteriaId) {
        return (T)this.setParam("profile_criteria_" + String.valueOf(profileCriteriaId), "nomatch");
    }

    public T withProfileCriteriaUnknown(Long profileCriteriaId) {
        return (T)this.setParam("profile_criteria_" + String.valueOf(profileCriteriaId), "unknown");
    }
}

