/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.request.login;

import com.darksci.pardot.api.auth.AuthorizationServer;
import com.darksci.pardot.api.request.BaseRequest;
import com.darksci.pardot.api.request.login.LoginRequestMarker;
import java.util.Objects;

public class SsoRefreshTokenRequest
extends BaseRequest<SsoRefreshTokenRequest>
implements LoginRequestMarker {
    private AuthorizationServer authorizationServer;

    public SsoRefreshTokenRequest() {
        this(AuthorizationServer.DEFAULT_SALESFORCE);
    }

    public SsoRefreshTokenRequest(AuthorizationServer authorizationServer) {
        this.authorizationServer = Objects.requireNonNull(authorizationServer);
        this.withGrantType("refresh_token");
    }

    public SsoRefreshTokenRequest withClientId(String clientId) {
        return (SsoRefreshTokenRequest)this.setParam("client_id", clientId);
    }

    public SsoRefreshTokenRequest withClientSecret(String clientSecret) {
        return (SsoRefreshTokenRequest)this.setParam("client_secret", clientSecret);
    }

    public SsoRefreshTokenRequest withRefreshToken(String refreshToken) {
        return (SsoRefreshTokenRequest)this.setParam("refresh_token", refreshToken);
    }

    public SsoRefreshTokenRequest withGrantType(String grantType) {
        return (SsoRefreshTokenRequest)this.setParam("grant_type", grantType);
    }

    public SsoRefreshTokenRequest withAuthorizationServer(AuthorizationServer authorizationServer) {
        this.authorizationServer = Objects.requireNonNull(authorizationServer);
        return this;
    }

    @Override
    public String getApiEndpoint() {
        return this.authorizationServer.getAuthUri();
    }

    @Override
    public String getApiHostname() {
        return this.authorizationServer.getAuthServer();
    }
}

