/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.request.login;

import com.darksci.pardot.api.auth.AuthorizationServer;
import com.darksci.pardot.api.request.BaseRequest;
import com.darksci.pardot.api.request.login.LoginRequestMarker;
import java.util.Objects;

public class SsoLoginRequest
extends BaseRequest<SsoLoginRequest>
implements LoginRequestMarker {
    private AuthorizationServer authorizationServer;

    public SsoLoginRequest() {
        this(AuthorizationServer.DEFAULT_SALESFORCE);
    }

    public SsoLoginRequest(AuthorizationServer authorizationServer) {
        this.authorizationServer = Objects.requireNonNull(authorizationServer);
        this.withGrantType("password");
    }

    public SsoLoginRequest withClientId(String clientId) {
        return (SsoLoginRequest)this.setParam("client_id", clientId);
    }

    public SsoLoginRequest withClientSecret(String clientSecret) {
        return (SsoLoginRequest)this.setParam("client_secret", clientSecret);
    }

    public SsoLoginRequest withUsername(String username) {
        return (SsoLoginRequest)this.setParam("username", username);
    }

    public SsoLoginRequest withPassword(String password) {
        return (SsoLoginRequest)this.setParam("password", password);
    }

    public SsoLoginRequest withGrantType(String grantType) {
        return (SsoLoginRequest)this.setParam("grant_type", grantType);
    }

    public SsoLoginRequest withAuthorizationServer(AuthorizationServer authorizationServer) {
        this.authorizationServer = Objects.requireNonNull(authorizationServer);
        return this;
    }

    @Override
    public String getApiEndpoint() {
        return this.authorizationServer.getAuthUri();
    }

    @Override
    public String getApiHostname() {
        return this.authorizationServer.getAuthServer();
    }
}

