/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.request;

public class DateParameter {
    private final String dateParameter;

    public DateParameter(String dateParameter) {
        this.dateParameter = dateParameter;
    }

    public static DateParameter today() {
        return new DateParameter("today");
    }

    public static DateParameter yesterday() {
        return new DateParameter("yesterday");
    }

    public static DateParameter last7Days() {
        return new DateParameter("last_7_days");
    }

    public static DateParameter thisMonth() {
        return new DateParameter("this_month");
    }

    public static DateParameter lastMonth() {
        return new DateParameter("last_month");
    }

    public static DateParameter custom(String gnuDateString) {
        return new DateParameter(gnuDateString);
    }

    public static DateParameter custom(int year, int month, int day) {
        return new DateParameter(year + "-" + month + "-" + day);
    }

    public static DateParameter custom(int year, int month, int day, int hour, int min, int sec) {
        String gnuDateStr = year + "-" + month + "-" + day + " ";
        if (hour < 10) {
            gnuDateStr = gnuDateStr + "0";
        }
        gnuDateStr = gnuDateStr + hour + ":";
        if (min < 10) {
            gnuDateStr = gnuDateStr + "0";
        }
        gnuDateStr = gnuDateStr + min + ":";
        if (sec < 10) {
            gnuDateStr = gnuDateStr + "0";
        }
        gnuDateStr = gnuDateStr + sec;
        return new DateParameter(gnuDateStr);
    }

    public String toString() {
        return this.dateParameter;
    }
}

