/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.config;

import com.darksci.pardot.api.ConfigurationBuilder;
import com.darksci.pardot.api.auth.SessionRefreshHandler;
import com.darksci.pardot.api.config.ProxyConfiguration;
import com.darksci.pardot.api.rest.interceptor.RequestInterceptor;
import java.util.Objects;

public class Configuration {
    private final SessionRefreshHandler sessionRefreshHandler;
    private final ProxyConfiguration proxyConfiguration;
    private final String pardotApiHost;
    private String pardotApiVersion;
    private final boolean ignoreInvalidSslCertificates;
    private final RequestInterceptor requestInterceptor;

    public static ConfigurationBuilder newBuilder() {
        return new ConfigurationBuilder();
    }

    public Configuration(SessionRefreshHandler sessionRefreshHandler, ProxyConfiguration proxyConfiguration, String pardotApiHost, String pardotApiVersion, boolean ignoreInvalidSslCertificates, RequestInterceptor requestInterceptor) {
        this.sessionRefreshHandler = Objects.requireNonNull(sessionRefreshHandler);
        this.proxyConfiguration = Objects.requireNonNull(proxyConfiguration);
        this.pardotApiHost = Objects.requireNonNull(pardotApiHost);
        this.pardotApiVersion = Objects.requireNonNull(pardotApiVersion);
        this.ignoreInvalidSslCertificates = ignoreInvalidSslCertificates;
        this.requestInterceptor = Objects.requireNonNull(requestInterceptor);
    }

    public SessionRefreshHandler getSessionRefreshHandler() {
        return this.sessionRefreshHandler;
    }

    public boolean hasProxyConfigured() {
        return this.proxyConfiguration.isConfigured();
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public boolean isIgnoreInvalidSslCertificates() {
        return this.ignoreInvalidSslCertificates;
    }

    public String getPardotApiHost() {
        return this.pardotApiHost;
    }

    public String getPardotApiVersion() {
        return this.pardotApiVersion;
    }

    public Configuration setPardotApiVersion(String pardotApiVersion) {
        this.pardotApiVersion = pardotApiVersion;
        return this;
    }

    public RequestInterceptor getRequestInterceptor() {
        return this.requestInterceptor;
    }

    public String toString() {
        return "Configuration{sessionRefreshHandler=" + this.sessionRefreshHandler.getClass().getSimpleName() + ", proxyConfiguration=" + this.proxyConfiguration + ", pardotApiHost='" + this.pardotApiHost + '\'' + ", pardotApiVersion='" + this.pardotApiVersion + '\'' + ", ignoreInvalidSslCertificates=" + this.ignoreInvalidSslCertificates + ", requestInterceptor=" + this.requestInterceptor + '}';
    }
}

