/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.auth;

import com.darksci.pardot.api.PardotClient;
import com.darksci.pardot.api.auth.AuthParameter;
import com.darksci.pardot.api.auth.AuthorizationServer;
import com.darksci.pardot.api.auth.SessionRefreshHandler;
import com.darksci.pardot.api.config.SsoLoginCredentials;
import com.darksci.pardot.api.request.login.SsoLoginRequest;
import com.darksci.pardot.api.response.login.SsoLoginResponse;
import java.util.Objects;

public class SsoSessionRefreshHandler
implements SessionRefreshHandler {
    private final SsoLoginCredentials credentials;
    private final AuthorizationServer authorizationServer;
    private String apiToken = null;

    public SsoSessionRefreshHandler(SsoLoginCredentials credentials, AuthorizationServer authorizationServer) {
        this.credentials = Objects.requireNonNull(credentials);
        this.authorizationServer = Objects.requireNonNull(authorizationServer);
    }

    @Override
    public boolean isValid() {
        return this.apiToken != null;
    }

    @Override
    public void clearToken() {
        this.apiToken = null;
    }

    @Override
    public boolean refreshCredentials(PardotClient client) {
        SsoLoginResponse response = client.login(new SsoLoginRequest(this.authorizationServer).withClientId(this.credentials.getClientId()).withClientSecret(this.credentials.getClientSecret()).withUsername(this.credentials.getUsername()).withPassword(this.credentials.getPassword()));
        if (response.getAccessToken() != null) {
            this.setApiToken(response.getAccessToken());
            return true;
        }
        return false;
    }

    @Override
    public AuthParameter[] getAuthorizationHeaders() {
        if (!this.isValid()) {
            return AuthParameter.EMPTY;
        }
        String value = "Bearer " + this.apiToken;
        return new AuthParameter[]{new AuthParameter("Authorization", value), new AuthParameter("Pardot-Business-Unit-Id", this.credentials.getBusinessUnitId())};
    }

    @Override
    public AuthParameter[] getAuthorizationRequestParameters() {
        return AuthParameter.EMPTY;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }
}

