/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.auth;

import com.darksci.pardot.api.PardotClient;
import com.darksci.pardot.api.auth.AuthParameter;
import com.darksci.pardot.api.auth.SessionRefreshHandler;
import com.darksci.pardot.api.config.SsoAccessTokenCredentials;
import java.util.Objects;

public class SsoAccessTokenSessionRefreshHandler
implements SessionRefreshHandler {
    private final SsoAccessTokenCredentials credentials;

    public SsoAccessTokenSessionRefreshHandler(SsoAccessTokenCredentials credentials) {
        this.credentials = Objects.requireNonNull(credentials);
    }

    @Override
    public boolean isValid() {
        return this.credentials.getAccessToken() != null;
    }

    @Override
    public void clearToken() {
    }

    @Override
    public boolean refreshCredentials(PardotClient client) {
        return false;
    }

    @Override
    public AuthParameter[] getAuthorizationHeaders() {
        if (!this.isValid()) {
            return AuthParameter.EMPTY;
        }
        String value = "Bearer " + this.credentials.getAccessToken();
        return new AuthParameter[]{new AuthParameter("Authorization", value), new AuthParameter("Pardot-Business-Unit-Id", this.credentials.getBusinessUnitId())};
    }

    @Override
    public AuthParameter[] getAuthorizationRequestParameters() {
        return AuthParameter.EMPTY;
    }
}

