/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.auth;

import com.darksci.pardot.api.InvalidRequestException;
import com.darksci.pardot.api.LoginFailedException;
import com.darksci.pardot.api.PardotClient;
import com.darksci.pardot.api.auth.AuthParameter;
import com.darksci.pardot.api.auth.SessionRefreshHandler;
import com.darksci.pardot.api.config.PasswordLoginCredentials;
import com.darksci.pardot.api.request.login.LoginRequest;
import com.darksci.pardot.api.response.login.LoginResponse;
import java.util.Objects;

public class PasswordSessionRefreshHandler
implements SessionRefreshHandler {
    private final PasswordLoginCredentials credentials;
    private String apiToken = null;

    public PasswordSessionRefreshHandler(PasswordLoginCredentials credentials) {
        this.credentials = Objects.requireNonNull(credentials);
    }

    @Override
    public boolean isValid() {
        return this.apiToken != null;
    }

    @Override
    public void clearToken() {
        this.apiToken = null;
    }

    @Override
    public boolean refreshCredentials(PardotClient client) {
        try {
            LoginResponse response = client.login(new LoginRequest().withEmail(this.credentials.getUsername()).withPassword(this.credentials.getPassword()));
            if (response.getApiKey() != null) {
                this.setApiToken(response.getApiKey());
                return true;
            }
        }
        catch (InvalidRequestException exception) {
            throw new LoginFailedException(exception.getMessage(), exception.getErrorCode(), exception);
        }
        return false;
    }

    @Override
    public AuthParameter[] getAuthorizationHeaders() {
        if (!this.isValid()) {
            return AuthParameter.EMPTY;
        }
        String value = "Pardot user_key=" + this.credentials.getUserKey() + ", api_key=" + this.apiToken;
        return new AuthParameter[]{new AuthParameter("Authorization", value)};
    }

    @Override
    public AuthParameter[] getAuthorizationRequestParameters() {
        return new AuthParameter[]{new AuthParameter("user_key", this.credentials.getUserKey())};
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }
}

