/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api;

import com.darksci.pardot.api.ConfigurationBuilder;
import com.darksci.pardot.api.InvalidRequestException;
import com.darksci.pardot.api.LoginFailedException;
import com.darksci.pardot.api.ParserException;
import com.darksci.pardot.api.auth.SessionRefreshHandler;
import com.darksci.pardot.api.config.Configuration;
import com.darksci.pardot.api.parser.DeleteResponseParser;
import com.darksci.pardot.api.parser.ErrorResponseParser;
import com.darksci.pardot.api.parser.ResponseParser;
import com.darksci.pardot.api.parser.account.AccountReadResponseParser;
import com.darksci.pardot.api.parser.campaign.CampaignQueryResponseParser;
import com.darksci.pardot.api.parser.campaign.CampaignReadResponseParser;
import com.darksci.pardot.api.parser.customfield.CustomFieldQueryResponseParser;
import com.darksci.pardot.api.parser.customfield.CustomFieldReadResponseParser;
import com.darksci.pardot.api.parser.customredirect.CustomRedirectQueryResponseParser;
import com.darksci.pardot.api.parser.customredirect.CustomRedirectReadResponseParser;
import com.darksci.pardot.api.parser.dynamiccontent.DynamicContentQueryResponseParser;
import com.darksci.pardot.api.parser.dynamiccontent.DynamicContentReadResponseParser;
import com.darksci.pardot.api.parser.email.EmailReadResponseParser;
import com.darksci.pardot.api.parser.email.EmailStatsResponseParser;
import com.darksci.pardot.api.parser.emailclick.EmailClickQueryResponseParser;
import com.darksci.pardot.api.parser.emailtemplate.EmailTemplateListOneToOneResponseParser;
import com.darksci.pardot.api.parser.emailtemplate.EmailTemplateReadResponseParser;
import com.darksci.pardot.api.parser.form.FormQueryResponseParser;
import com.darksci.pardot.api.parser.form.FormReadResponseParser;
import com.darksci.pardot.api.parser.list.ListQueryResponseParser;
import com.darksci.pardot.api.parser.list.ListReadResponseParser;
import com.darksci.pardot.api.parser.listmembership.ListMembershipQueryResponseParser;
import com.darksci.pardot.api.parser.listmembership.ListMembershipReadResponseParser;
import com.darksci.pardot.api.parser.login.LoginResponseParser;
import com.darksci.pardot.api.parser.login.SsoLoginErrorResponseParser;
import com.darksci.pardot.api.parser.login.SsoLoginResponseParser;
import com.darksci.pardot.api.parser.opportunity.OpportunityQueryResponseParser;
import com.darksci.pardot.api.parser.opportunity.OpportunityReadResponseParser;
import com.darksci.pardot.api.parser.prospect.ProspectQueryResponseParser;
import com.darksci.pardot.api.parser.prospect.ProspectReadResponseParser;
import com.darksci.pardot.api.parser.tag.TagQueryResponseParser;
import com.darksci.pardot.api.parser.tag.TagReadResponseParser;
import com.darksci.pardot.api.parser.tagobject.TagObjectQueryResponseParser;
import com.darksci.pardot.api.parser.tagobject.TagObjectReadResponseParser;
import com.darksci.pardot.api.parser.user.UserAbilitiesParser;
import com.darksci.pardot.api.parser.user.UserCookieParser;
import com.darksci.pardot.api.parser.user.UserCreateResponseParser;
import com.darksci.pardot.api.parser.user.UserQueryResponseParser;
import com.darksci.pardot.api.parser.user.UserReadResponseParser;
import com.darksci.pardot.api.parser.visit.VisitQueryResponseParser;
import com.darksci.pardot.api.parser.visit.VisitReadResponseParser;
import com.darksci.pardot.api.parser.visitor.VisitorQueryResponseParser;
import com.darksci.pardot.api.parser.visitor.VisitorReadResponseParser;
import com.darksci.pardot.api.parser.visitoractivity.VisitorActivityQueryResponseParser;
import com.darksci.pardot.api.parser.visitoractivity.VisitorActivityReadResponseParser;
import com.darksci.pardot.api.request.Request;
import com.darksci.pardot.api.request.UserDefinedRequest;
import com.darksci.pardot.api.request.account.AccountReadRequest;
import com.darksci.pardot.api.request.campaign.CampaignCreateRequest;
import com.darksci.pardot.api.request.campaign.CampaignQueryRequest;
import com.darksci.pardot.api.request.campaign.CampaignReadRequest;
import com.darksci.pardot.api.request.campaign.CampaignUpdateRequest;
import com.darksci.pardot.api.request.customfield.CustomFieldCreateRequest;
import com.darksci.pardot.api.request.customfield.CustomFieldDeleteRequest;
import com.darksci.pardot.api.request.customfield.CustomFieldQueryRequest;
import com.darksci.pardot.api.request.customfield.CustomFieldReadRequest;
import com.darksci.pardot.api.request.customfield.CustomFieldUpdateRequest;
import com.darksci.pardot.api.request.customredirect.CustomRedirectQueryRequest;
import com.darksci.pardot.api.request.customredirect.CustomRedirectReadRequest;
import com.darksci.pardot.api.request.dynamiccontent.DynamicContentQueryRequest;
import com.darksci.pardot.api.request.dynamiccontent.DynamicContentReadRequest;
import com.darksci.pardot.api.request.email.EmailReadRequest;
import com.darksci.pardot.api.request.email.EmailSendListRequest;
import com.darksci.pardot.api.request.email.EmailSendOneToOneRequest;
import com.darksci.pardot.api.request.email.EmailStatsRequest;
import com.darksci.pardot.api.request.emailclick.EmailClickQueryRequest;
import com.darksci.pardot.api.request.emailtemplate.EmailTemplateListOneToOneRequest;
import com.darksci.pardot.api.request.emailtemplate.EmailTemplateReadRequest;
import com.darksci.pardot.api.request.form.FormCreateRequest;
import com.darksci.pardot.api.request.form.FormDeleteRequest;
import com.darksci.pardot.api.request.form.FormQueryRequest;
import com.darksci.pardot.api.request.form.FormReadRequest;
import com.darksci.pardot.api.request.form.FormUpdateRequest;
import com.darksci.pardot.api.request.list.ListCreateRequest;
import com.darksci.pardot.api.request.list.ListQueryRequest;
import com.darksci.pardot.api.request.list.ListReadRequest;
import com.darksci.pardot.api.request.list.ListUpdateRequest;
import com.darksci.pardot.api.request.listmembership.ListMembershipCreateRequest;
import com.darksci.pardot.api.request.listmembership.ListMembershipQueryRequest;
import com.darksci.pardot.api.request.listmembership.ListMembershipReadRequest;
import com.darksci.pardot.api.request.listmembership.ListMembershipUpdateRequest;
import com.darksci.pardot.api.request.login.LoginRequest;
import com.darksci.pardot.api.request.login.LoginRequestMarker;
import com.darksci.pardot.api.request.login.SsoLoginRequest;
import com.darksci.pardot.api.request.login.SsoRefreshTokenRequest;
import com.darksci.pardot.api.request.opportunity.OpportunityCreateRequest;
import com.darksci.pardot.api.request.opportunity.OpportunityDeleteRequest;
import com.darksci.pardot.api.request.opportunity.OpportunityQueryRequest;
import com.darksci.pardot.api.request.opportunity.OpportunityReadRequest;
import com.darksci.pardot.api.request.opportunity.OpportunityUndeleteRequest;
import com.darksci.pardot.api.request.opportunity.OpportunityUpdateRequest;
import com.darksci.pardot.api.request.prospect.ProspectAssignRequest;
import com.darksci.pardot.api.request.prospect.ProspectCreateRequest;
import com.darksci.pardot.api.request.prospect.ProspectDeleteRequest;
import com.darksci.pardot.api.request.prospect.ProspectQueryRequest;
import com.darksci.pardot.api.request.prospect.ProspectReadRequest;
import com.darksci.pardot.api.request.prospect.ProspectUnassignRequest;
import com.darksci.pardot.api.request.prospect.ProspectUpdateRequest;
import com.darksci.pardot.api.request.prospect.ProspectUpsertRequest;
import com.darksci.pardot.api.request.tag.TagQueryRequest;
import com.darksci.pardot.api.request.tag.TagReadRequest;
import com.darksci.pardot.api.request.tagobject.TagObjectQueryRequest;
import com.darksci.pardot.api.request.tagobject.TagObjectReadRequest;
import com.darksci.pardot.api.request.user.UserAbilitiesRequest;
import com.darksci.pardot.api.request.user.UserCookieRequest;
import com.darksci.pardot.api.request.user.UserCreateRequest;
import com.darksci.pardot.api.request.user.UserDeleteRequest;
import com.darksci.pardot.api.request.user.UserQueryRequest;
import com.darksci.pardot.api.request.user.UserReadRequest;
import com.darksci.pardot.api.request.user.UserUpdateRoleRequest;
import com.darksci.pardot.api.request.visit.VisitQueryRequest;
import com.darksci.pardot.api.request.visit.VisitReadRequest;
import com.darksci.pardot.api.request.visitor.VisitorAssignRequest;
import com.darksci.pardot.api.request.visitor.VisitorQueryRequest;
import com.darksci.pardot.api.request.visitor.VisitorReadRequest;
import com.darksci.pardot.api.request.visitoractivity.VisitorActivityQueryRequest;
import com.darksci.pardot.api.request.visitoractivity.VisitorActivityReadRequest;
import com.darksci.pardot.api.response.ErrorCode;
import com.darksci.pardot.api.response.ErrorResponse;
import com.darksci.pardot.api.response.Result;
import com.darksci.pardot.api.response.account.Account;
import com.darksci.pardot.api.response.campaign.Campaign;
import com.darksci.pardot.api.response.campaign.CampaignQueryResponse;
import com.darksci.pardot.api.response.customfield.CustomField;
import com.darksci.pardot.api.response.customfield.CustomFieldQueryResponse;
import com.darksci.pardot.api.response.customredirect.CustomRedirect;
import com.darksci.pardot.api.response.customredirect.CustomRedirectQueryResponse;
import com.darksci.pardot.api.response.dynamiccontent.DynamicContent;
import com.darksci.pardot.api.response.dynamiccontent.DynamicContentQueryResponse;
import com.darksci.pardot.api.response.email.Email;
import com.darksci.pardot.api.response.email.EmailStatsResponse;
import com.darksci.pardot.api.response.emailclick.EmailClickQueryResponse;
import com.darksci.pardot.api.response.emailtemplate.EmailTemplate;
import com.darksci.pardot.api.response.emailtemplate.EmailTemplateListOneToOneResponse;
import com.darksci.pardot.api.response.form.Form;
import com.darksci.pardot.api.response.form.FormQueryResponse;
import com.darksci.pardot.api.response.list.List;
import com.darksci.pardot.api.response.list.ListMembership;
import com.darksci.pardot.api.response.list.ListQueryResponse;
import com.darksci.pardot.api.response.listmembership.ListMembershipQueryResponse;
import com.darksci.pardot.api.response.login.LoginResponse;
import com.darksci.pardot.api.response.login.SsoLoginErrorResponse;
import com.darksci.pardot.api.response.login.SsoLoginResponse;
import com.darksci.pardot.api.response.opportunity.Opportunity;
import com.darksci.pardot.api.response.opportunity.OpportunityQueryResponse;
import com.darksci.pardot.api.response.prospect.Prospect;
import com.darksci.pardot.api.response.prospect.ProspectQueryResponse;
import com.darksci.pardot.api.response.tag.Tag;
import com.darksci.pardot.api.response.tag.TagQueryResponse;
import com.darksci.pardot.api.response.tagobject.TagObject;
import com.darksci.pardot.api.response.tagobject.TagObjectQueryResponse;
import com.darksci.pardot.api.response.user.Cookie;
import com.darksci.pardot.api.response.user.User;
import com.darksci.pardot.api.response.user.UserAbilitiesResponse;
import com.darksci.pardot.api.response.user.UserQueryResponse;
import com.darksci.pardot.api.response.visit.Visit;
import com.darksci.pardot.api.response.visit.VisitQueryResponse;
import com.darksci.pardot.api.response.visitor.Visitor;
import com.darksci.pardot.api.response.visitor.VisitorQueryResponse;
import com.darksci.pardot.api.response.visitoractivity.VisitorActivity;
import com.darksci.pardot.api.response.visitoractivity.VisitorActivityQueryResponse;
import com.darksci.pardot.api.rest.HttpClientRestClient;
import com.darksci.pardot.api.rest.RestClient;
import com.darksci.pardot.api.rest.RestResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PardotClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(PardotClient.class);
    private final Configuration configuration;
    private final SessionRefreshHandler sessionRefreshHandler;
    private final RestClient restClient;
    private boolean isInitialized = false;

    public PardotClient(ConfigurationBuilder configurationBuilder) {
        this(configurationBuilder, (RestClient)new HttpClientRestClient());
    }

    public PardotClient(ConfigurationBuilder configurationBuilder, RestClient restClient) {
        this(Objects.requireNonNull(configurationBuilder).build(), Objects.requireNonNull(restClient));
    }

    PardotClient(Configuration configuration, RestClient restClient) {
        this.configuration = Objects.requireNonNull(configuration);
        this.restClient = Objects.requireNonNull(restClient);
        this.sessionRefreshHandler = Objects.requireNonNull(configuration.getSessionRefreshHandler());
    }

    private <T> Result<T> submitRequest(Request request, ResponseParser<T> responseParser) {
        if (!(request instanceof LoginRequestMarker)) {
            this.checkLogin();
        }
        RestResponse restResponse = this.getRestClient().submitRequest(request);
        int responseCode = restResponse.getHttpCode();
        String responseStr = restResponse.getResponseStr();
        if (!(request instanceof LoginRequestMarker)) {
            logger.info("Response: {}", (Object)restResponse);
        }
        if (responseCode >= 200 && responseCode < 300 && (responseCode == 204 || responseCode == 205) && responseStr == null) {
            responseStr = "";
        }
        if (responseStr.contains("<rsp stat=\"fail\"")) {
            try {
                ErrorResponse error = new ErrorResponseParser().parseResponse(responseStr);
                if (ErrorCode.INVALID_API_OR_USER_KEY.getCode() == error.getCode() || ErrorCode.INVALID_ACCESS_TOKEN.getCode() == error.getCode()) {
                    this.sessionRefreshHandler.clearToken();
                    this.checkLogin();
                    return this.submitRequest(request, responseParser);
                }
                if (ErrorCode.WRONG_API_VERSION.getCode() == error.getCode() && !"4".equals(this.configuration.getPardotApiVersion())) {
                    logger.info("Detected API version 4 should be used, retrying request with API Version 4.");
                    this.configuration.setPardotApiVersion("4");
                    return this.submitRequest(request, responseParser);
                }
                return Result.newFailure(error);
            }
            catch (IOException exception) {
                throw new ParserException(exception.getMessage(), exception);
            }
        }
        if (responseCode < 200 || responseCode >= 300) {
            if (request instanceof SsoLoginRequest) {
                try {
                    SsoLoginErrorResponse errorResponse = new SsoLoginErrorResponseParser().parseResponse(responseStr);
                    throw new LoginFailedException("[" + errorResponse.getError() + "] " + errorResponse.getDescription(), responseCode);
                }
                catch (IOException exception) {
                    throw new ParserException(exception.getMessage(), exception);
                }
            }
            throw new InvalidRequestException("Invalid http response code from server: " + restResponse.getHttpCode(), restResponse.getHttpCode());
        }
        try {
            return Result.newSuccess(responseParser.parseResponse(restResponse.getResponseStr()));
        }
        catch (IOException exception) {
            throw new ParserException(exception.getMessage(), exception);
        }
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    RestClient getRestClient() {
        if (!this.isInitialized) {
            this.restClient.init(this.getConfiguration());
            this.isInitialized = true;
        }
        return this.restClient;
    }

    private void checkLogin() {
        if (this.sessionRefreshHandler.isValid()) {
            return;
        }
        if (!this.sessionRefreshHandler.refreshCredentials(this)) {
            throw new LoginFailedException("SessionRefreshHandler " + this.sessionRefreshHandler.getClass().getSimpleName() + " failed to refresh authentication token", 0);
        }
    }

    public LoginResponse login(LoginRequest request) {
        LoginResponse loginResponse = this.submitRequest(request, new LoginResponseParser()).handleError(errorResponse -> {
            if (ErrorCode.LOGIN_FAILED.getCode() == errorResponse.getCode()) {
                throw new LoginFailedException(errorResponse.getMessage(), errorResponse.getCode());
            }
            throw new InvalidRequestException(errorResponse.getMessage(), errorResponse.getCode());
        });
        if (!loginResponse.getApiVersion().equals(this.getConfiguration().getPardotApiVersion())) {
            logger.info("Upgrading API version from {} to {}", (Object)this.getConfiguration().getPardotApiVersion(), (Object)loginResponse.getApiVersion());
            this.getConfiguration().setPardotApiVersion(loginResponse.getApiVersion());
        }
        return loginResponse;
    }

    public SsoLoginResponse login(SsoLoginRequest request) {
        try {
            return this.submitRequest(request, new SsoLoginResponseParser()).get();
        }
        catch (InvalidRequestException exception) {
            if (exception instanceof LoginFailedException) {
                throw exception;
            }
            throw new LoginFailedException(exception.getMessage(), exception.getErrorCode(), exception);
        }
    }

    public SsoLoginResponse login(SsoRefreshTokenRequest request) {
        try {
            return this.submitRequest(request, new SsoLoginResponseParser()).get();
        }
        catch (InvalidRequestException exception) {
            if (exception instanceof LoginFailedException) {
                throw exception;
            }
            throw new LoginFailedException(exception.getMessage(), exception.getErrorCode(), exception);
        }
    }

    public Account accountRead(AccountReadRequest request) {
        return this.submitRequest(request, new AccountReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public UserQueryResponse.Result userQuery(UserQueryRequest request) {
        return this.submitRequest(request, new UserQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public UserAbilitiesResponse.Result userAbilities(UserAbilitiesRequest request) {
        return this.submitRequest(request, new UserAbilitiesParser()).orElseThrowInvalidRequestException();
    }

    public Cookie userCookie(UserCookieRequest request) {
        return this.submitRequest(request, new UserCookieParser()).orElseThrowInvalidRequestException();
    }

    public Optional<User> userRead(UserReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new UserReadResponseParser()), ErrorCode.INVALID_USER_ID);
    }

    public Result<Boolean> userDelete(UserDeleteRequest request) {
        return this.submitRequest(request, new DeleteResponseParser());
    }

    public User userCreate(UserCreateRequest request) {
        return this.submitRequest(request, new UserCreateResponseParser()).orElseThrowInvalidRequestException().getUser();
    }

    public User userUpdateRole(UserUpdateRoleRequest request) {
        return this.submitRequest(request, new UserReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public CampaignQueryResponse.Result campaignQuery(CampaignQueryRequest request) {
        return this.submitRequest(request, new CampaignQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<Campaign> campaignRead(CampaignReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new CampaignReadResponseParser()), ErrorCode.INVALID_ID);
    }

    public Campaign campaignCreate(CampaignCreateRequest request) {
        return this.submitRequest(request, new CampaignReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public Campaign campaignUpdate(CampaignUpdateRequest request) {
        return this.submitRequest(request, new CampaignReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public CustomFieldQueryResponse.Result customFieldQuery(CustomFieldQueryRequest request) {
        return this.submitRequest(request, new CustomFieldQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<CustomField> customFieldRead(CustomFieldReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new CustomFieldReadResponseParser()), ErrorCode.INVALID_ID);
    }

    public CustomField customFieldCreate(CustomFieldCreateRequest request) {
        return this.submitRequest(request, new CustomFieldReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public CustomField customFieldUpdate(CustomFieldUpdateRequest request) {
        return this.submitRequest(request, new CustomFieldReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public Result<Boolean> customFieldDelete(CustomFieldDeleteRequest request) {
        return this.submitRequest(request, new DeleteResponseParser());
    }

    public CustomRedirectQueryResponse.Result customRedirectQuery(CustomRedirectQueryRequest request) {
        return this.submitRequest(request, new CustomRedirectQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<CustomRedirect> customRedirectRead(CustomRedirectReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new CustomRedirectReadResponseParser()), ErrorCode.INVALID_ID);
    }

    public DynamicContentQueryResponse.Result dynamicContentQuery(DynamicContentQueryRequest request) {
        return this.submitRequest(request, new DynamicContentQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<DynamicContent> dynamicContentRead(DynamicContentReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new DynamicContentReadResponseParser()), ErrorCode.INVALID_ID);
    }

    public Optional<Email> emailRead(EmailReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new EmailReadResponseParser()), ErrorCode.INVALID_ID);
    }

    public Optional<EmailStatsResponse.Stats> emailStats(EmailStatsRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new EmailStatsResponseParser()), ErrorCode.INVALID_ID);
    }

    public Email emailSendOneToOne(EmailSendOneToOneRequest request) {
        return this.submitRequest(request, new EmailReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public Email emailSendList(EmailSendListRequest request) {
        return this.submitRequest(request, new EmailReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public EmailClickQueryResponse.Result emailClickQuery(EmailClickQueryRequest request) {
        return this.submitRequest(request, new EmailClickQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<EmailTemplate> emailTemplateRead(EmailTemplateReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new EmailTemplateReadResponseParser()), ErrorCode.INVALID_ID, ErrorCode.INVALID_EMAIL_TEMPLATE);
    }

    public EmailTemplateListOneToOneResponse.Result emailTemplateListOneToOne() {
        return this.submitRequest(new EmailTemplateListOneToOneRequest(), new EmailTemplateListOneToOneResponseParser()).orElseThrowInvalidRequestException();
    }

    public Form formCreate(FormCreateRequest request) {
        return this.submitRequest(request, new FormReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public Result<Boolean> formDelete(FormDeleteRequest request) {
        return this.submitRequest(request, new DeleteResponseParser());
    }

    public FormQueryResponse.Result formQuery(FormQueryRequest request) {
        return this.submitRequest(request, new FormQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<Form> formRead(FormReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new FormReadResponseParser()), ErrorCode.INVALID_ID);
    }

    public Form formUpdate(FormUpdateRequest request) {
        return this.submitRequest(request, new FormReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public ListQueryResponse.Result listQuery(ListQueryRequest request) {
        return this.submitRequest(request, new ListQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<List> listRead(ListReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new ListReadResponseParser()), ErrorCode.INVALID_ID);
    }

    public List listCreate(ListCreateRequest request) {
        return this.submitRequest(request, new ListReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public List listUpdate(ListUpdateRequest request) {
        return this.submitRequest(request, new ListReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public ListMembershipQueryResponse.Result listMembershipQuery(ListMembershipQueryRequest request) {
        return this.submitRequest(request, new ListMembershipQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<ListMembership> listMembershipRead(ListMembershipReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new ListMembershipReadResponseParser()), ErrorCode.INVALID_LIST_ID, ErrorCode.INVALID_ID);
    }

    public ListMembership listMembershipCreate(ListMembershipCreateRequest request) {
        return this.submitRequest(request, new ListMembershipReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public ListMembership listMembershipUpdate(ListMembershipUpdateRequest request) {
        return this.submitRequest(request, new ListMembershipReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public OpportunityQueryResponse.Result opportunityQuery(OpportunityQueryRequest request) {
        return this.submitRequest(request, new OpportunityQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<Opportunity> opportunityRead(OpportunityReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new OpportunityReadResponseParser()), ErrorCode.INVALID_ID, ErrorCode.INVALID_OPPORTUNITY_ID);
    }

    public Opportunity opportunityCreate(OpportunityCreateRequest request) {
        return this.submitRequest(request, new OpportunityReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public Opportunity opportunityUpdate(OpportunityUpdateRequest request) {
        return this.submitRequest(request, new OpportunityReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public Result<Boolean> opportunityDelete(OpportunityDeleteRequest request) {
        return this.submitRequest(request, new DeleteResponseParser());
    }

    public Result<Boolean> opportunityUndelete(OpportunityUndeleteRequest request) {
        return this.submitRequest(request, new DeleteResponseParser());
    }

    public Optional<Prospect> prospectRead(ProspectReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new ProspectReadResponseParser()), ErrorCode.INVALID_ID, ErrorCode.INVALID_PROSPECT_ID, ErrorCode.INVALID_PROSPECT_EMAIL_ADDRESS);
    }

    public Prospect prospectCreate(ProspectCreateRequest request) {
        return this.submitRequest(request, new ProspectReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public Prospect prospectUpdate(ProspectUpdateRequest request) {
        return this.submitRequest(request, new ProspectReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public Prospect prospectUpsert(ProspectUpsertRequest request) {
        return this.submitRequest(request, new ProspectReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public ProspectQueryResponse.Result prospectQuery(ProspectQueryRequest request) {
        return this.submitRequest(request, new ProspectQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Result<Boolean> prospectDelete(ProspectDeleteRequest request) {
        return this.submitRequest(request, new DeleteResponseParser());
    }

    public Prospect prospectAssign(ProspectAssignRequest request) {
        return this.submitRequest(request, new ProspectReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public Prospect prospectUnassign(ProspectUnassignRequest request) {
        return this.submitRequest(request, new ProspectReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public TagQueryResponse.Result tagQuery(TagQueryRequest request) {
        return this.submitRequest(request, new TagQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<Tag> tagRead(TagReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new TagReadResponseParser()), ErrorCode.INVALID_ID);
    }

    public TagObjectQueryResponse.Result tagObjectQuery(TagObjectQueryRequest request) {
        return this.submitRequest(request, new TagObjectQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<TagObject> tagObjectRead(TagObjectReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new TagObjectReadResponseParser()), ErrorCode.INVALID_ID);
    }

    public Visitor visitorAssign(VisitorAssignRequest request) {
        return this.submitRequest(request, new VisitorReadResponseParser()).orElseThrowInvalidRequestException();
    }

    public VisitorQueryResponse.Result visitorQuery(VisitorQueryRequest request) {
        return this.submitRequest(request, new VisitorQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<Visitor> visitorRead(VisitorReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new VisitorReadResponseParser()), ErrorCode.INVALID_ID, ErrorCode.INVALID_VISITOR_ID);
    }

    public VisitorActivityQueryResponse.Result visitorActivityQuery(VisitorActivityQueryRequest request) {
        return this.submitRequest(request, new VisitorActivityQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<VisitorActivity> visitorActivityRead(VisitorActivityReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new VisitorActivityReadResponseParser()), ErrorCode.INVALID_ID);
    }

    public VisitQueryResponse.Result visitQuery(VisitQueryRequest request) {
        return this.submitRequest(request, new VisitQueryResponseParser()).orElseThrowInvalidRequestException();
    }

    public Optional<Visit> visitRead(VisitReadRequest request) {
        return this.optionalUnlessErrorCode(this.submitRequest(request, new VisitReadResponseParser()), ErrorCode.INVALID_ID, ErrorCode.INVALID_VISIT_ID);
    }

    public <Self, ResponseObject> Result<ResponseObject> userDefinedRequest(UserDefinedRequest<Self, ResponseObject> request) {
        return this.submitRequest(request, request.getResponseParser());
    }

    @Override
    public void close() {
        this.getRestClient().close();
    }

    private <T> Optional<T> optionalUnlessErrorCode(Result<T> result, ErrorCode ... errorCodes) {
        return Optional.ofNullable(result.handleError(errorResponse -> {
            boolean matchedErrorCode = Arrays.stream(errorCodes).anyMatch(errorCode -> errorCode.getCode() == result.getFailure().getCode());
            if (matchedErrorCode) {
                return null;
            }
            throw new InvalidRequestException(result.getFailure().getMessage(), result.getFailure().getCode());
        }));
    }
}

