/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api;

import com.darksci.pardot.api.ConfigurationBuilder;
import com.darksci.pardot.api.PardotClient;
import com.darksci.pardot.api.auth.AuthorizationServer;
import com.darksci.pardot.api.config.Configuration;
import com.darksci.pardot.api.request.DateParameter;
import com.darksci.pardot.api.request.account.AccountReadRequest;
import com.darksci.pardot.api.request.campaign.CampaignQueryRequest;
import com.darksci.pardot.api.response.account.Account;
import com.darksci.pardot.api.response.campaign.CampaignQueryResponse;

public class Example {
    public static void example_salesforceSsoAuthentication() {
        ConfigurationBuilder configuration = Configuration.newBuilder().withSsoLogin("YourSalesforceUsername", "YourSalesforcePassword", "YourConnectedAppClientId", "YourConnectedAppClientSecret", "YourPardotBusinessUnitId");
        configuration.withApiVersion3();
        configuration.withApiVersion4();
        PardotClient client = new PardotClient(configuration);
        AccountReadRequest accountReadRequest = new AccountReadRequest();
        Account account = client.accountRead(accountReadRequest);
        CampaignQueryRequest campaignQueryRequest = (CampaignQueryRequest)((CampaignQueryRequest)new CampaignQueryRequest().withUpdatedAfter(DateParameter.last7Days()).withIdLessThan(1234L)).withSortById().withSortOrderDescending();
        CampaignQueryResponse.Result campaignQueryResponse = client.campaignQuery(campaignQueryRequest);
        client.close();
    }

    public static void example_salesforceSsoRefreshTokenAuthentication() {
        ConfigurationBuilder configuration = Configuration.newBuilder().withSsoRefreshTokenLogin("YourPreviouslyAcquiredRefreshToken", "YourConnectedAppClientId", "YourConnectedAppClientSecret", "YourPardotBusinessUnitId");
        configuration.withApiVersion3();
        configuration.withApiVersion4();
        PardotClient client = new PardotClient(configuration);
        AccountReadRequest accountReadRequest = new AccountReadRequest();
        Account account = client.accountRead(accountReadRequest);
        CampaignQueryRequest campaignQueryRequest = (CampaignQueryRequest)((CampaignQueryRequest)new CampaignQueryRequest().withUpdatedAfter(DateParameter.last7Days()).withIdLessThan(1234L)).withSortById().withSortOrderDescending();
        CampaignQueryResponse.Result campaignQueryResponse = client.campaignQuery(campaignQueryRequest);
        client.close();
    }

    public static void example_salesforceSso_sandboxAuthorizationOrg() {
        ConfigurationBuilder configuration = Configuration.newBuilder();
        configuration.withSsoLogin("YourSalesforceUsername", "YourSalesforcePassword", "YourConnectedAppClientId", "YourConnectedAppClientSecret", "YourPardotBusinessUnitId", AuthorizationServer.SANDBOX_SALESFORCE);
        configuration.withSsoRefreshTokenLogin("YourPreviouslyAcquiredRefreshToken", "YourConnectedAppClientId", "YourConnectedAppClientSecret", "YourPardotBusinessUnitId", AuthorizationServer.SANDBOX_SALESFORCE);
    }

    public static void example_pardotUsernameAndPasswordAuthentication() {
        ConfigurationBuilder configuration = Configuration.newBuilder().withUsernameAndPasswordLogin("YourPardotUsername", "YourPardotPassword", "YourPardotUserKey");
        configuration.withApiVersion3();
        configuration.withApiVersion4();
        PardotClient client = new PardotClient(configuration);
        AccountReadRequest accountReadRequest = new AccountReadRequest();
        Account account = client.accountRead(accountReadRequest);
        CampaignQueryRequest campaignQueryRequest = (CampaignQueryRequest)((CampaignQueryRequest)new CampaignQueryRequest().withUpdatedAfter(DateParameter.last7Days()).withIdLessThan(1234L)).withSortById().withSortOrderDescending();
        CampaignQueryResponse.Result campaignQueryResponse = client.campaignQuery(campaignQueryRequest);
        client.close();
    }

    public static void autoCloseableExample() {
        ConfigurationBuilder configuration = Configuration.newBuilder().withUsernameAndPasswordLogin("YourPardotUserNameHere", "PardotPassword", "UserKey");
        try (PardotClient client = new PardotClient(configuration);){
            client.accountRead(new AccountReadRequest());
        }
    }
}

