/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api;

import com.darksci.pardot.api.auth.AuthorizationServer;
import com.darksci.pardot.api.auth.PasswordSessionRefreshHandler;
import com.darksci.pardot.api.auth.SessionRefreshHandler;
import com.darksci.pardot.api.auth.SsoAccessTokenSessionRefreshHandler;
import com.darksci.pardot.api.auth.SsoRefreshTokenSessionRefreshHandler;
import com.darksci.pardot.api.auth.SsoSessionRefreshHandler;
import com.darksci.pardot.api.config.Configuration;
import com.darksci.pardot.api.config.PasswordLoginCredentials;
import com.darksci.pardot.api.config.ProxyConfiguration;
import com.darksci.pardot.api.config.SsoAccessTokenCredentials;
import com.darksci.pardot.api.config.SsoLoginCredentials;
import com.darksci.pardot.api.config.SsoRefreshTokenCredentials;
import com.darksci.pardot.api.rest.interceptor.NoopRequestInterceptor;
import com.darksci.pardot.api.rest.interceptor.RequestInterceptor;
import java.util.Objects;

public class ConfigurationBuilder {
    private SessionRefreshHandler sessionRefreshHandler = null;
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyScheme = "HTTP";
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String pardotApiHost = "https://pi.pardot.com/api";
    private String pardotApiVersion = "3";
    private boolean ignoreInvalidSslCertificates = false;
    private RequestInterceptor requestInterceptor = new NoopRequestInterceptor();

    public ConfigurationBuilder withUsernameAndPasswordLogin(String username, String password, String userKey) {
        return this.withCustomAuthenticationHandler(new PasswordSessionRefreshHandler(new PasswordLoginCredentials(Objects.requireNonNull(username), Objects.requireNonNull(password), Objects.requireNonNull(userKey))));
    }

    public ConfigurationBuilder withSsoLogin(String username, String password, String clientId, String clientSecret, String businessUnitId) {
        return this.withCustomAuthenticationHandler(new SsoSessionRefreshHandler(new SsoLoginCredentials(Objects.requireNonNull(username), Objects.requireNonNull(password), Objects.requireNonNull(clientId), Objects.requireNonNull(clientSecret), Objects.requireNonNull(businessUnitId)), AuthorizationServer.DEFAULT_SALESFORCE));
    }

    public ConfigurationBuilder withSsoLogin(String username, String password, String clientId, String clientSecret, String businessUnitId, AuthorizationServer authorizationServer) {
        return this.withCustomAuthenticationHandler(new SsoSessionRefreshHandler(new SsoLoginCredentials(Objects.requireNonNull(username), Objects.requireNonNull(password), Objects.requireNonNull(clientId), Objects.requireNonNull(clientSecret), Objects.requireNonNull(businessUnitId)), authorizationServer));
    }

    public ConfigurationBuilder withSsoRefreshTokenLogin(String refreshToken, String clientId, String clientSecret, String businessUnitId) {
        return this.withCustomAuthenticationHandler(new SsoRefreshTokenSessionRefreshHandler(new SsoRefreshTokenCredentials(Objects.requireNonNull(refreshToken), Objects.requireNonNull(clientId), Objects.requireNonNull(clientSecret), Objects.requireNonNull(businessUnitId)), AuthorizationServer.DEFAULT_SALESFORCE));
    }

    public ConfigurationBuilder withSsoRefreshTokenLogin(String refreshToken, String clientId, String clientSecret, String businessUnitId, AuthorizationServer authorizationServer) {
        return this.withCustomAuthenticationHandler(new SsoRefreshTokenSessionRefreshHandler(new SsoRefreshTokenCredentials(Objects.requireNonNull(refreshToken), Objects.requireNonNull(clientId), Objects.requireNonNull(clientSecret), Objects.requireNonNull(businessUnitId)), authorizationServer));
    }

    public ConfigurationBuilder withSsoAccessTokenLogin(String accessToken, String clientId, String clientSecret, String businessUnitId) {
        return this.withCustomAuthenticationHandler(new SsoAccessTokenSessionRefreshHandler(new SsoAccessTokenCredentials(Objects.requireNonNull(accessToken), Objects.requireNonNull(clientId), Objects.requireNonNull(clientSecret), Objects.requireNonNull(businessUnitId))));
    }

    public ConfigurationBuilder withCustomAuthenticationHandler(SessionRefreshHandler sessionRefreshHandler) {
        this.sessionRefreshHandler = Objects.requireNonNull(sessionRefreshHandler);
        return this;
    }

    public ConfigurationBuilder withProxyHttp(String proxyHost, int proxyPort) {
        return this.withProxy(proxyHost, proxyPort, "HTTP");
    }

    public ConfigurationBuilder withProxyHttps(String proxyHost, int proxyPort) {
        return this.withProxy(proxyHost, proxyPort, "HTTPS");
    }

    public ConfigurationBuilder withProxy(String proxyHost, int proxyPort, String proxyScheme) {
        this.proxyHost = Objects.requireNonNull(proxyHost);
        this.proxyPort = proxyPort;
        this.proxyScheme = Objects.requireNonNull(proxyScheme);
        return this;
    }

    public ConfigurationBuilder useProxyAuthentication(String proxyUsername, String proxyPassword) {
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        return this;
    }

    public ConfigurationBuilder withProductionApiHost() {
        return this.withPardotApiHost("https://pi.pardot.com/api");
    }

    public ConfigurationBuilder withDemoApiHost() {
        return this.withPardotApiHost("https://pi.demo.pardot.com/api");
    }

    public ConfigurationBuilder withPardotApiHost(String pardotApiHost) {
        this.pardotApiHost = Objects.requireNonNull(pardotApiHost);
        return this;
    }

    public ConfigurationBuilder withApiVersion4() {
        return this.withApiVersion("4");
    }

    public ConfigurationBuilder withApiVersion3() {
        return this.withApiVersion("3");
    }

    public ConfigurationBuilder withApiVersion(String apiVersion) {
        this.pardotApiVersion = apiVersion;
        return this;
    }

    public ConfigurationBuilder withIgnoreInvalidSslCertificates() {
        return this.withIgnoreInvalidSslCertificates(true);
    }

    public ConfigurationBuilder withIgnoreInvalidSslCertificates(boolean ignoreInvalidSslCertificates) {
        this.ignoreInvalidSslCertificates = ignoreInvalidSslCertificates;
        return this;
    }

    public ConfigurationBuilder withRequestInterceptor(RequestInterceptor requestInterceptor) {
        this.requestInterceptor = Objects.requireNonNull(requestInterceptor);
        return this;
    }

    public Configuration build() {
        ProxyConfiguration proxyConfiguration = this.proxyHost == null ? new ProxyConfiguration() : new ProxyConfiguration(this.proxyHost, this.proxyPort, this.proxyScheme, this.proxyUsername, this.proxyPassword);
        return new Configuration(this.sessionRefreshHandler, proxyConfiguration, this.pardotApiHost, this.pardotApiVersion, this.ignoreInvalidSslCertificates, this.requestInterceptor);
    }
}

