/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.rest;

import com.darksci.pardot.api.Configuration;
import com.darksci.pardot.api.request.Request;
import com.darksci.pardot.api.rest.RestClient;
import com.darksci.pardot.api.rest.RestException;
import com.darksci.pardot.api.rest.RestResponse;
import com.darksci.pardot.api.rest.handlers.RestResponseHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRestClient
implements RestClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientRestClient.class);
    private Configuration configuration;
    private CloseableHttpClient httpClient;

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        SSLContext sslcontext = SSLContexts.createDefault();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1.1", "TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        clientBuilder.setConnectionTimeToLive(130L, TimeUnit.SECONDS).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (configuration.getProxyHost() != null) {
            HttpHost proxyHost = new HttpHost(configuration.getProxyHost(), configuration.getProxyPort(), configuration.getProxyScheme());
            if (configuration.getProxyUsername() != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(configuration.getProxyHost(), configuration.getProxyPort()), (Credentials)new UsernamePasswordCredentials(configuration.getProxyUsername(), configuration.getProxyPassword()));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            requestConfigBuilder.setProxy(proxyHost);
        }
        clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        this.httpClient = clientBuilder.build();
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.error("Error closing: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.httpClient = null;
    }

    @Override
    public RestResponse submitRequest(Request request) throws RestException {
        try {
            return this.submitRequest(request, new RestResponseHandler());
        }
        catch (IOException exception) {
            throw new RestException(exception.getMessage(), exception);
        }
    }

    private <T> T submitRequest(Request request, ResponseHandler<T> responseHandler) throws IOException {
        String url = this.constructApiUrl(request.getApiEndpoint());
        return this.submitRequest(url, request.getRequestParameters(), responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T submitRequest(String url, Map<String, String> postParams, ResponseHandler<T> responseHandler) throws IOException {
        try {
            HttpPost post = new HttpPost(url);
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add((NameValuePair)new BasicNameValuePair("user_key", this.configuration.getUserKey()));
            if (this.configuration.getApiKey() != null) {
                params.add((NameValuePair)new BasicNameValuePair("api_key", this.configuration.getApiKey()));
            }
            for (Map.Entry<String, String> entry : postParams.entrySet()) {
                params.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            logger.info("Executing request {} with {}", (Object)post.getRequestLine(), this.filterSensitiveParams(params));
            Object object = this.httpClient.execute((HttpUriRequest)post, responseHandler);
            return (T)object;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String constructApiUrl(String endPoint) {
        return this.configuration.getPardotApiHost() + "/" + endPoint + "/version/" + this.configuration.getPardotApiVersion();
    }

    private List<NameValuePair> filterSensitiveParams(List<NameValuePair> inputParams) {
        String[] sensitiveFields = new String[]{"user_key", "password", "api_key"};
        ArrayList<NameValuePair> copiedList = new ArrayList<NameValuePair>();
        copiedList.addAll(inputParams);
        for (String sensitiveField : sensitiveFields) {
            if (!copiedList.removeIf(nameValuePair -> nameValuePair.getName().equals(sensitiveField))) continue;
            copiedList.add((NameValuePair)new BasicNameValuePair(sensitiveField, "XXXXXXX"));
        }
        return copiedList;
    }
}

