/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.response.opportunity;

import com.darksci.pardot.api.response.campaign.Campaign;
import com.darksci.pardot.api.response.prospect.Prospect;
import com.darksci.pardot.api.response.visitoractivity.VisitorActivity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;

public class Opportunity {
    private Long id;
    private String name;
    private Integer value;
    private Integer probability;
    private String type;
    private String stage;
    private String status;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private DateTime createdAt;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private DateTime updatedAt;
    private Campaign campaign;
    @JacksonXmlProperty(localName="prospects")
    private Prospects prospects = new Prospects();
    @JacksonXmlProperty(localName="opportunity_activities")
    private OpportunityActivities opportunityActivities = new OpportunityActivities();

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getProbability() {
        return this.probability;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public String getStage() {
        return this.stage;
    }

    public String getStatus() {
        return this.status;
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public List<Prospect> getProspects() {
        if (this.prospects == null) {
            this.prospects = new Prospects();
        }
        return this.prospects.getProspects();
    }

    public List<VisitorActivity> getOpportunityActivities() {
        if (this.opportunityActivities == null) {
            this.opportunityActivities = new OpportunityActivities();
        }
        return this.opportunityActivities.getVisitorActivities();
    }

    public String toString() {
        return "Opportunity{id=" + this.id + ", name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", probability=" + this.probability + ", type='" + this.type + '\'' + ", stage='" + this.stage + '\'' + ", status='" + this.status + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", campaign=" + this.campaign + ", prospects=" + this.getProspects() + ", opportunityActivities=" + this.getOpportunityActivities() + '}';
    }

    private static class OpportunityActivities {
        @JacksonXmlProperty(localName="visitor_activity")
        private List<VisitorActivity> visitorActivities = Collections.emptyList();

        private OpportunityActivities() {
        }

        private List<VisitorActivity> getVisitorActivities() {
            if (this.visitorActivities == null) {
                this.visitorActivities = Collections.emptyList();
            }
            return Collections.unmodifiableList(this.visitorActivities);
        }
    }

    private static class Prospects {
        @JacksonXmlProperty(localName="prospect")
        private List<Prospect> prospects = Collections.emptyList();

        private Prospects() {
        }

        private List<Prospect> getProspects() {
            if (this.prospects == null) {
                this.prospects = Collections.emptyList();
            }
            return Collections.unmodifiableList(this.prospects);
        }
    }
}

