/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.request.prospect;

import com.darksci.pardot.api.request.BaseQueryRequest;
import com.darksci.pardot.api.request.DateParameter;
import java.util.Collection;
import java.util.stream.Collectors;

public class ProspectQueryRequest
extends BaseQueryRequest<ProspectQueryRequest> {
    @Override
    public String getApiEndpoint() {
        return "prospect/do/query";
    }

    public ProspectQueryRequest withFields(Collection<String> fields) {
        String fieldsStr = fields.stream().collect(Collectors.joining(","));
        String currentValue = (String)this.getParam("fields");
        if (currentValue == null) {
            return (ProspectQueryRequest)this.setParam("fields", fieldsStr);
        }
        return (ProspectQueryRequest)this.setParam("fields", currentValue + "," + fieldsStr);
    }

    public ProspectQueryRequest withField(String field) {
        String currentValue = (String)this.getParam("fields");
        if (currentValue == null) {
            return (ProspectQueryRequest)this.setParam("fields", field);
        }
        return (ProspectQueryRequest)this.setParam("fields", currentValue + "," + field);
    }

    public ProspectQueryRequest withAssignedOnly() {
        return (ProspectQueryRequest)this.setBooleanParam("assigned", true);
    }

    public ProspectQueryRequest withUnassignedOnly() {
        return (ProspectQueryRequest)this.setBooleanParam("assigned", false);
    }

    public ProspectQueryRequest withAssignedUser(Long userId) {
        return (ProspectQueryRequest)this.setParam("assigned_to_user", userId);
    }

    public ProspectQueryRequest withAssignUser(String userEmail) {
        return (ProspectQueryRequest)this.setParam("assigned_to_user", userEmail);
    }

    public ProspectQueryRequest withArchivedOnly() {
        return (ProspectQueryRequest)super.withArchivedOnly(true);
    }

    public ProspectQueryRequest withNotArchivedOnly() {
        return (ProspectQueryRequest)super.withArchivedOnly(false);
    }

    public ProspectQueryRequest withGradeEqualTo(String grade) {
        return (ProspectQueryRequest)this.setParam("grade_equal_to", grade);
    }

    public ProspectQueryRequest withGradeGreaterThan(String grade) {
        return (ProspectQueryRequest)this.setParam("grade_greater_than", grade);
    }

    public ProspectQueryRequest withGradeLessThan(String grade) {
        return (ProspectQueryRequest)this.setParam("grade_less_than", grade);
    }

    public ProspectQueryRequest withStarredOnly() {
        return (ProspectQueryRequest)this.setBooleanParam("is_starred", true);
    }

    public ProspectQueryRequest withNotStarredOnly() {
        return (ProspectQueryRequest)this.setBooleanParam("is_starred", false);
    }

    public ProspectQueryRequest withLastActivityAfter(DateParameter lastActivityAfter) {
        return (ProspectQueryRequest)this.setParam("last_activity_after", lastActivityAfter);
    }

    public ProspectQueryRequest withNonActiveOnly() {
        return (ProspectQueryRequest)this.setBooleanParam("last_activity_never", true);
    }

    public ProspectQueryRequest withListId(Long listId) {
        return (ProspectQueryRequest)this.setParam("list_id", listId);
    }

    public ProspectQueryRequest withNewOnly() {
        return (ProspectQueryRequest)this.setBooleanParam("new", true);
    }

    public ProspectQueryRequest withNotNewOnly() {
        return (ProspectQueryRequest)this.setBooleanParam("new", false);
    }

    public ProspectQueryRequest withScoreEqualTo(Integer score) {
        return (ProspectQueryRequest)this.setParam("score_equal_to", score);
    }

    public ProspectQueryRequest withScoreGreaterThan(Integer score) {
        return (ProspectQueryRequest)this.setParam("score_greater_than", score);
    }

    public ProspectQueryRequest withScoreLessThan(Integer score) {
        return (ProspectQueryRequest)this.setParam("score_less_than", score);
    }

    @Override
    public ProspectQueryRequest withSortByCreatedAt() {
        return (ProspectQueryRequest)super.withSortByCreatedAt();
    }

    @Override
    public ProspectQueryRequest withSortByUpdatedAt() {
        return (ProspectQueryRequest)super.withSortByUpdatedAt();
    }

    public ProspectQueryRequest withSortByProbability() {
        return (ProspectQueryRequest)this.withSortBy("probability");
    }

    public ProspectQueryRequest withSortByLastActivityAt() {
        return (ProspectQueryRequest)this.withSortBy("last_activity_at");
    }

    @Override
    public ProspectQueryRequest withSortById() {
        return (ProspectQueryRequest)super.withSortById();
    }
}

