/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.request.prospect;

import com.darksci.pardot.api.request.BaseRequest;
import com.darksci.pardot.api.response.prospect.Prospect;
import java.util.Map;

abstract class ProspectModifyRequest<T>
extends BaseRequest<T> {
    ProspectModifyRequest() {
    }

    public T withProspect(Prospect prospect) {
        this.setParam("id", prospect.getId());
        this.setParam("email", prospect.getEmail());
        this.setParam("first_name", prospect.getFirstName());
        this.setParam("last_name", prospect.getLastName());
        this.setParam("campaign_id", prospect.getCampaignId());
        this.setParam("salutation", prospect.getSalutation());
        this.setParam("company", prospect.getCompany());
        this.setParam("prospect_account_d", prospect.getProspectAccountId());
        this.setParam("website", prospect.getWebsite());
        this.setParam("job_title", prospect.getJobTitle());
        this.setParam("department", prospect.getDepartment());
        this.setParam("country", prospect.getCountry());
        this.setParam("address_one", prospect.getAddressOne());
        this.setParam("address_two", prospect.getAddressTwo());
        this.setParam("city", prospect.getCity());
        this.setParam("state", prospect.getState());
        this.setParam("territory", prospect.getTerritory());
        this.setParam("zip", prospect.getZip());
        this.setParam("phone", prospect.getPhone());
        this.setParam("fax", prospect.getFax());
        this.setParam("source", prospect.getSource());
        this.setParam("annual_revenue", prospect.getAnnualRevenue());
        this.setParam("employees", prospect.getEmployees());
        this.setParam("industry", prospect.getIndustry());
        this.setParam("years_in_business", prospect.getYearsInBusiness());
        if (prospect.getCustomFields() != null) {
            for (Map.Entry<String, String> entry : prospect.getCustomFields().entrySet()) {
                this.setParam(entry.getKey(), entry.getValue());
            }
        }
        return (T)this;
    }

    public T withFieldValueCleared(String fieldName) {
        return this.setParam(fieldName, "");
    }

    public T withFieldValue(String fieldName, Object value) {
        return this.setParam(fieldName, value);
    }

    public T withSubscribeToList(Long listId) {
        return this.setParam("list_" + String.valueOf(listId), "1");
    }

    public T withUnsubscribeFromList(Long listId) {
        return this.setParam("list_" + String.valueOf(listId), "0");
    }

    public T withProfileCriteriaMatching(Long profileCriteriaId) {
        return this.setParam("profile_criteria_" + String.valueOf(profileCriteriaId), "match");
    }

    public T withProfileCriteriaNotMatching(Long profileCriteriaId) {
        return this.setParam("profile_criteria_" + String.valueOf(profileCriteriaId), "nomatch");
    }

    public T withProfileCriteriaUnknown(Long profileCriteriaId) {
        return this.setParam("profile_criteria_" + String.valueOf(profileCriteriaId), "unknown");
    }
}

