/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.request.opportunity;

import com.darksci.pardot.api.request.BaseRequest;
import com.darksci.pardot.api.response.opportunity.Opportunity;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class OpportunityCreateRequest
extends BaseRequest<OpportunityCreateRequest> {
    @Override
    public String getApiEndpoint() {
        return "opportunity/do/create";
    }

    public OpportunityCreateRequest withOpportunity(Opportunity opportunity) {
        this.withName(opportunity.getName()).withValue(opportunity.getValue()).withProbability(opportunity.getProbability()).withType(opportunity.getType()).withStage(opportunity.getStage()).withStatus(opportunity.getStatus());
        if (opportunity.getCampaign() != null) {
            this.withCampaignId(opportunity.getCampaign().getId());
        }
        if (opportunity.getProspects().size() > 0) {
            this.withProspectId(opportunity.getProspects().get(0).getId());
        }
        return this;
    }

    public OpportunityCreateRequest withName(String name) {
        return (OpportunityCreateRequest)this.setParam("name", name);
    }

    public OpportunityCreateRequest withCampaignId(Long campaignId) {
        return (OpportunityCreateRequest)this.setParam("campaign_id", campaignId);
    }

    public OpportunityCreateRequest withValue(Integer value) {
        return (OpportunityCreateRequest)this.setParam("value", value);
    }

    public OpportunityCreateRequest withProbability(Integer probability) {
        return (OpportunityCreateRequest)this.setParam("probability", probability);
    }

    public OpportunityCreateRequest withType(String type) {
        return (OpportunityCreateRequest)this.setParam("type", type);
    }

    public OpportunityCreateRequest withStage(String stage) {
        return (OpportunityCreateRequest)this.setParam("stage", stage);
    }

    public OpportunityCreateRequest withStatus(String status) {
        return (OpportunityCreateRequest)this.setParam("status", status);
    }

    public OpportunityCreateRequest withStatusWon() {
        return this.withStatus("won");
    }

    public OpportunityCreateRequest withStatusLost() {
        return this.withStatus("lost");
    }

    public OpportunityCreateRequest withStatusOpen() {
        return this.withStatus("open");
    }

    public OpportunityCreateRequest withProspectId(Long prospectId) {
        this.setParam("prospect_email", null);
        return (OpportunityCreateRequest)this.setParam("prospect_id", prospectId);
    }

    public OpportunityCreateRequest withProspectEmail(String prospectEmail) {
        this.setParam("prospect_email", prospectEmail);
        return (OpportunityCreateRequest)this.setParam("prospect_id", null);
    }

    public OpportunityCreateRequest withClosedAt(Long unixTimestampSecs) {
        return this.withClosedAt(LocalDateTime.ofEpochSecond(unixTimestampSecs, 0, ZoneOffset.UTC));
    }

    public OpportunityCreateRequest withClosedAt(LocalDateTime closedAt) {
        return (OpportunityCreateRequest)this.setParam("closed_at", closedAt.toString());
    }
}

