/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.request;

import com.darksci.pardot.api.request.Request;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public abstract class BaseRequest<T>
implements Request {
    private Map<String, Object> params = new HashMap<String, Object>();

    protected <T> T getParam(String name) {
        return this.params.getOrDefault(name, null);
    }

    protected T setParam(String name, Object value) {
        if (value == null) {
            this.params.remove(name);
        } else {
            this.params.put(name, value);
        }
        return (T)this;
    }

    protected T setBooleanParam(String parameterName, boolean booleanValue) {
        return this.setParam(parameterName, booleanValue);
    }

    protected T withCollectionParam(String name, Object value) {
        if (value == null) {
            return this.setParam(name, null);
        }
        if (value instanceof Collection) {
            return this.withCollectionParams(name, (Collection)value);
        }
        LinkedHashSet<Object> existingValues = (LinkedHashSet<Object>)this.getParam(name);
        if (existingValues == null) {
            existingValues = new LinkedHashSet<Object>();
        }
        existingValues.add(value);
        return this.setParam(name, existingValues);
    }

    protected T withCollectionParams(String name, Collection<?> values) {
        for (Object value : values) {
            this.withCollectionParam(name, value);
        }
        return (T)this;
    }

    @Override
    public Map<String, String> getRequestParameters() {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            String parameterName = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Collection) {
                int index = 0;
                for (Object object : (Collection)value) {
                    requestParams.put(parameterName + "[" + index + "]", object.toString());
                    ++index;
                }
                continue;
            }
            requestParams.put(parameterName, entry.getValue().toString());
        }
        return requestParams;
    }
}

