/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api.parser;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResponseHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(ResponseHandler.class);
    private final ObjectMapper mapper;

    public ResponseHandler() {
        JacksonXmlModule module = new JacksonXmlModule();
        module.setDefaultUseWrapper(false);
        this.mapper = new XmlMapper(module);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).registerModule((Module)new JodaModule()).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }

    public abstract T parseResponse(String var1) throws IOException;

    protected ObjectMapper getMapper() {
        return this.mapper;
    }

    protected void logResponse(String response) {
        logger.info("Response: {}", (Object)response);
    }
}

