/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api;

import com.darksci.pardot.api.Configuration;
import com.darksci.pardot.api.InvalidRequestException;
import com.darksci.pardot.api.LoginFailedException;
import com.darksci.pardot.api.ParserException;
import com.darksci.pardot.api.parser.ErrorResponseParser;
import com.darksci.pardot.api.parser.ResponseParser;
import com.darksci.pardot.api.parser.StringResponseParser;
import com.darksci.pardot.api.parser.account.AccountReadResponseParser;
import com.darksci.pardot.api.parser.campaign.CampaignQueryResponseParser;
import com.darksci.pardot.api.parser.campaign.CampaignReadResponseParser;
import com.darksci.pardot.api.parser.customfield.CustomFieldQueryResponseParser;
import com.darksci.pardot.api.parser.customfield.CustomFieldReadResponseParser;
import com.darksci.pardot.api.parser.customredirect.CustomRedirectQueryResponseParser;
import com.darksci.pardot.api.parser.customredirect.CustomRedirectReadResponseParser;
import com.darksci.pardot.api.parser.email.EmailReadResponseParser;
import com.darksci.pardot.api.parser.email.EmailStatsResponseParser;
import com.darksci.pardot.api.parser.emailclick.EmailClickQueryResponseParser;
import com.darksci.pardot.api.parser.emailtemplate.EmailTemplateListOneToOneResponseParser;
import com.darksci.pardot.api.parser.emailtemplate.EmailTemplateReadResponseParser;
import com.darksci.pardot.api.parser.form.FormQueryResponseParser;
import com.darksci.pardot.api.parser.form.FormReadResponseParser;
import com.darksci.pardot.api.parser.list.ListQueryResponseParser;
import com.darksci.pardot.api.parser.list.ListReadResponseParser;
import com.darksci.pardot.api.parser.listmembership.ListMembershipQueryResponseParser;
import com.darksci.pardot.api.parser.listmembership.ListMembershipReadResponseParser;
import com.darksci.pardot.api.parser.login.LoginResponseParser;
import com.darksci.pardot.api.parser.opportunity.OpportunityQueryResponseParser;
import com.darksci.pardot.api.parser.opportunity.OpportunityReadResponseParser;
import com.darksci.pardot.api.parser.prospect.ProspectQueryResponseParser;
import com.darksci.pardot.api.parser.prospect.ProspectReadResponseParser;
import com.darksci.pardot.api.parser.tag.TagQueryResponseParser;
import com.darksci.pardot.api.parser.tag.TagReadResponseParser;
import com.darksci.pardot.api.parser.tagobject.TagObjectQueryResponseParser;
import com.darksci.pardot.api.parser.tagobject.TagObjectReadResponseParser;
import com.darksci.pardot.api.parser.user.UserAbilitiesParser;
import com.darksci.pardot.api.parser.user.UserQueryResponseParser;
import com.darksci.pardot.api.parser.user.UserReadResponseParser;
import com.darksci.pardot.api.parser.visitor.VisitorQueryResponseParser;
import com.darksci.pardot.api.parser.visitor.VisitorReadResponseParser;
import com.darksci.pardot.api.parser.visitoractivity.VisitorActivityQueryResponseParser;
import com.darksci.pardot.api.parser.visitoractivity.VisitorActivityReadResponseParser;
import com.darksci.pardot.api.request.Request;
import com.darksci.pardot.api.request.account.AccountReadRequest;
import com.darksci.pardot.api.request.campaign.CampaignCreateRequest;
import com.darksci.pardot.api.request.campaign.CampaignQueryRequest;
import com.darksci.pardot.api.request.campaign.CampaignReadRequest;
import com.darksci.pardot.api.request.campaign.CampaignUpdateRequest;
import com.darksci.pardot.api.request.customfield.CustomFieldCreateRequest;
import com.darksci.pardot.api.request.customfield.CustomFieldDeleteRequest;
import com.darksci.pardot.api.request.customfield.CustomFieldQueryRequest;
import com.darksci.pardot.api.request.customfield.CustomFieldReadRequest;
import com.darksci.pardot.api.request.customfield.CustomFieldUpdateRequest;
import com.darksci.pardot.api.request.customredirect.CustomRedirectQueryRequest;
import com.darksci.pardot.api.request.customredirect.CustomRedirectReadRequest;
import com.darksci.pardot.api.request.email.EmailReadRequest;
import com.darksci.pardot.api.request.email.EmailSendListRequest;
import com.darksci.pardot.api.request.email.EmailSendOneToOneRequest;
import com.darksci.pardot.api.request.email.EmailStatsRequest;
import com.darksci.pardot.api.request.emailclick.EmailClickQueryRequest;
import com.darksci.pardot.api.request.emailtemplate.EmailTemplateListOneToOneRequest;
import com.darksci.pardot.api.request.emailtemplate.EmailTemplateReadRequest;
import com.darksci.pardot.api.request.form.FormCreateRequest;
import com.darksci.pardot.api.request.form.FormDeleteRequest;
import com.darksci.pardot.api.request.form.FormQueryRequest;
import com.darksci.pardot.api.request.form.FormReadRequest;
import com.darksci.pardot.api.request.form.FormUpdateRequest;
import com.darksci.pardot.api.request.list.ListCreateRequest;
import com.darksci.pardot.api.request.list.ListQueryRequest;
import com.darksci.pardot.api.request.list.ListReadRequest;
import com.darksci.pardot.api.request.list.ListUpdateRequest;
import com.darksci.pardot.api.request.listmembership.ListMembershipCreateRequest;
import com.darksci.pardot.api.request.listmembership.ListMembershipQueryRequest;
import com.darksci.pardot.api.request.listmembership.ListMembershipReadRequest;
import com.darksci.pardot.api.request.listmembership.ListMembershipUpdateRequest;
import com.darksci.pardot.api.request.login.LoginRequest;
import com.darksci.pardot.api.request.opportunity.OpportunityCreateRequest;
import com.darksci.pardot.api.request.opportunity.OpportunityDeleteRequest;
import com.darksci.pardot.api.request.opportunity.OpportunityQueryRequest;
import com.darksci.pardot.api.request.opportunity.OpportunityReadRequest;
import com.darksci.pardot.api.request.opportunity.OpportunityUndeleteRequest;
import com.darksci.pardot.api.request.opportunity.OpportunityUpdateRequest;
import com.darksci.pardot.api.request.prospect.ProspectAssignRequest;
import com.darksci.pardot.api.request.prospect.ProspectCreateRequest;
import com.darksci.pardot.api.request.prospect.ProspectDeleteRequest;
import com.darksci.pardot.api.request.prospect.ProspectQueryRequest;
import com.darksci.pardot.api.request.prospect.ProspectReadRequest;
import com.darksci.pardot.api.request.prospect.ProspectUnassignRequest;
import com.darksci.pardot.api.request.prospect.ProspectUpdateRequest;
import com.darksci.pardot.api.request.prospect.ProspectUpsertRequest;
import com.darksci.pardot.api.request.tag.TagQueryRequest;
import com.darksci.pardot.api.request.tag.TagReadRequest;
import com.darksci.pardot.api.request.tagobject.TagObjectQueryRequest;
import com.darksci.pardot.api.request.tagobject.TagObjectReadRequest;
import com.darksci.pardot.api.request.user.UserAbilitiesRequest;
import com.darksci.pardot.api.request.user.UserQueryRequest;
import com.darksci.pardot.api.request.user.UserReadRequest;
import com.darksci.pardot.api.request.visitor.VisitorAssignRequest;
import com.darksci.pardot.api.request.visitor.VisitorQueryRequest;
import com.darksci.pardot.api.request.visitor.VisitorReadRequest;
import com.darksci.pardot.api.request.visitoractivity.VisitorActivityQueryRequest;
import com.darksci.pardot.api.request.visitoractivity.VisitorActivityReadRequest;
import com.darksci.pardot.api.response.ErrorResponse;
import com.darksci.pardot.api.response.account.Account;
import com.darksci.pardot.api.response.campaign.Campaign;
import com.darksci.pardot.api.response.campaign.CampaignQueryResponse;
import com.darksci.pardot.api.response.customfield.CustomField;
import com.darksci.pardot.api.response.customfield.CustomFieldQueryResponse;
import com.darksci.pardot.api.response.customredirect.CustomRedirect;
import com.darksci.pardot.api.response.customredirect.CustomRedirectQueryResponse;
import com.darksci.pardot.api.response.email.Email;
import com.darksci.pardot.api.response.email.EmailStatsResponse;
import com.darksci.pardot.api.response.emailclick.EmailClickQueryResponse;
import com.darksci.pardot.api.response.emailtemplate.EmailTemplate;
import com.darksci.pardot.api.response.emailtemplate.EmailTemplateListOneToOneResponse;
import com.darksci.pardot.api.response.form.Form;
import com.darksci.pardot.api.response.form.FormQueryResponse;
import com.darksci.pardot.api.response.list.List;
import com.darksci.pardot.api.response.list.ListMembership;
import com.darksci.pardot.api.response.list.ListQueryResponse;
import com.darksci.pardot.api.response.listmembership.ListMembershipQueryResponse;
import com.darksci.pardot.api.response.login.LoginResponse;
import com.darksci.pardot.api.response.opportunity.Opportunity;
import com.darksci.pardot.api.response.opportunity.OpportunityQueryResponse;
import com.darksci.pardot.api.response.prospect.Prospect;
import com.darksci.pardot.api.response.prospect.ProspectQueryResponse;
import com.darksci.pardot.api.response.tag.Tag;
import com.darksci.pardot.api.response.tag.TagQueryResponse;
import com.darksci.pardot.api.response.tagobject.TagObject;
import com.darksci.pardot.api.response.tagobject.TagObjectQueryResponse;
import com.darksci.pardot.api.response.user.User;
import com.darksci.pardot.api.response.user.UserAbilitiesResponse;
import com.darksci.pardot.api.response.user.UserQueryResponse;
import com.darksci.pardot.api.response.visitor.Visitor;
import com.darksci.pardot.api.response.visitor.VisitorQueryResponse;
import com.darksci.pardot.api.response.visitoractivity.VisitorActivity;
import com.darksci.pardot.api.response.visitoractivity.VisitorActivityQueryResponse;
import com.darksci.pardot.api.rest.HttpClientRestClient;
import com.darksci.pardot.api.rest.RestClient;
import com.darksci.pardot.api.rest.RestResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PardotClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(PardotClient.class);
    private final Configuration configuration;
    private final RestClient restClient;
    private boolean isInitialized = false;

    public PardotClient(Configuration configuration) {
        this.configuration = configuration;
        this.restClient = new HttpClientRestClient();
    }

    public PardotClient(Configuration configuration, RestClient restClient) {
        this.configuration = configuration;
        this.restClient = restClient;
    }

    private <T> T submitRequest(Request request, ResponseParser<T> responseParser) {
        if (!(request instanceof LoginRequest)) {
            this.checkLogin();
        }
        RestResponse restResponse = this.getRestClient().submitRequest(request);
        int responseCode = restResponse.getHttpCode();
        String responseStr = restResponse.getResponseStr();
        logger.info("Response: {}", (Object)restResponse);
        if (responseCode >= 200 && responseCode < 300) {
            if ((responseCode == 204 || responseCode == 205) && responseStr == null) {
                responseStr = "";
            }
            if (responseStr.contains("<rsp stat=\"fail\"")) {
                try {
                    ErrorResponse error = new ErrorResponseParser().parseResponse(restResponse.getResponseStr());
                    throw new InvalidRequestException(error.getMessage(), error.getCode());
                }
                catch (IOException exception) {
                    throw new ParserException(exception.getMessage(), exception);
                }
            }
            try {
                return responseParser.parseResponse(restResponse.getResponseStr());
            }
            catch (IOException exception) {
                throw new ParserException(exception.getMessage(), exception);
            }
        }
        throw new InvalidRequestException("Invalid http response code from server: " + restResponse.getHttpCode(), restResponse.getHttpCode());
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    RestClient getRestClient() {
        if (!this.isInitialized) {
            this.restClient.init(this.getConfiguration());
            this.isInitialized = true;
        }
        return this.restClient;
    }

    private void checkLogin() {
        if (this.configuration.getApiKey() != null) {
            return;
        }
        try {
            LoginResponse response = this.login(new LoginRequest().withEmail(this.configuration.getEmail()).withPassword(this.configuration.getPassword()));
            if (response.getApiKey() != null) {
                this.getConfiguration().setApiKey(response.getApiKey());
            }
        }
        catch (InvalidRequestException exception) {
            throw new LoginFailedException(exception.getMessage(), exception.getErrorCode(), exception);
        }
    }

    public LoginResponse login(LoginRequest request) {
        try {
            LoginResponse loginResponse = this.submitRequest(request, new LoginResponseParser());
            if (!loginResponse.getApiVersion().equals(this.getConfiguration().getPardotApiVersion())) {
                logger.info("Upgrading API version from {} to {}", (Object)this.getConfiguration().getPardotApiVersion(), (Object)loginResponse.getApiVersion());
                this.getConfiguration().setPardotApiVersion(loginResponse.getApiVersion());
            }
            return loginResponse;
        }
        catch (InvalidRequestException exception) {
            throw new LoginFailedException(exception.getMessage(), exception.getErrorCode(), exception);
        }
    }

    public Account accountRead(AccountReadRequest request) {
        return this.submitRequest(request, new AccountReadResponseParser());
    }

    public UserQueryResponse.Result userQuery(UserQueryRequest request) {
        return this.submitRequest(request, new UserQueryResponseParser());
    }

    public UserAbilitiesResponse.Result userAbilities(UserAbilitiesRequest request) {
        return this.submitRequest(request, new UserAbilitiesParser());
    }

    public User userRead(UserReadRequest request) {
        return this.submitRequest(request, new UserReadResponseParser());
    }

    public CampaignQueryResponse.Result campaignQuery(CampaignQueryRequest request) {
        return this.submitRequest(request, new CampaignQueryResponseParser());
    }

    public Campaign campaignRead(CampaignReadRequest request) {
        return this.submitRequest(request, new CampaignReadResponseParser());
    }

    public Campaign campaignCreate(CampaignCreateRequest request) {
        return this.submitRequest(request, new CampaignReadResponseParser());
    }

    public Campaign campaignUpdate(CampaignUpdateRequest request) {
        return this.submitRequest(request, new CampaignReadResponseParser());
    }

    public CustomFieldQueryResponse.Result customFieldQuery(CustomFieldQueryRequest request) {
        return this.submitRequest(request, new CustomFieldQueryResponseParser());
    }

    public CustomField customFieldRead(CustomFieldReadRequest request) {
        return this.submitRequest(request, new CustomFieldReadResponseParser());
    }

    public CustomField customFieldCreate(CustomFieldCreateRequest request) {
        return this.submitRequest(request, new CustomFieldReadResponseParser());
    }

    public CustomField customFieldUpdate(CustomFieldUpdateRequest request) {
        return this.submitRequest(request, new CustomFieldReadResponseParser());
    }

    public boolean customFieldDelete(CustomFieldDeleteRequest request) {
        this.submitRequest(request, new StringResponseParser());
        return true;
    }

    public CustomRedirectQueryResponse.Result customRedirectQuery(CustomRedirectQueryRequest request) {
        return this.submitRequest(request, new CustomRedirectQueryResponseParser());
    }

    public CustomRedirect customRedirectRead(CustomRedirectReadRequest request) {
        return this.submitRequest(request, new CustomRedirectReadResponseParser());
    }

    public Email emailRead(EmailReadRequest request) {
        return this.submitRequest(request, new EmailReadResponseParser());
    }

    public EmailStatsResponse.Stats emailStats(EmailStatsRequest request) {
        return this.submitRequest(request, new EmailStatsResponseParser());
    }

    public Email emailSendOneToOne(EmailSendOneToOneRequest request) {
        return this.submitRequest(request, new EmailReadResponseParser());
    }

    public Email emailSendList(EmailSendListRequest request) {
        return this.submitRequest(request, new EmailReadResponseParser());
    }

    public EmailClickQueryResponse.Result emailClickQuery(EmailClickQueryRequest request) {
        return this.submitRequest(request, new EmailClickQueryResponseParser());
    }

    public EmailTemplate emailTemplateRead(EmailTemplateReadRequest request) {
        return this.submitRequest(request, new EmailTemplateReadResponseParser());
    }

    public EmailTemplateListOneToOneResponse.Result emailTemplateListOneToOne() {
        return this.submitRequest(new EmailTemplateListOneToOneRequest(), new EmailTemplateListOneToOneResponseParser());
    }

    public Form formCreate(FormCreateRequest request) {
        return this.submitRequest(request, new FormReadResponseParser());
    }

    public boolean formDelete(FormDeleteRequest request) {
        this.submitRequest(request, new StringResponseParser());
        return true;
    }

    public FormQueryResponse.Result formQuery(FormQueryRequest request) {
        return this.submitRequest(request, new FormQueryResponseParser());
    }

    public Form formRead(FormReadRequest request) {
        return this.submitRequest(request, new FormReadResponseParser());
    }

    public Form formUpdate(FormUpdateRequest request) {
        return this.submitRequest(request, new FormReadResponseParser());
    }

    public ListQueryResponse.Result listQuery(ListQueryRequest request) {
        return this.submitRequest(request, new ListQueryResponseParser());
    }

    public List listRead(ListReadRequest request) {
        return this.submitRequest(request, new ListReadResponseParser());
    }

    public List listCreate(ListCreateRequest request) {
        return this.submitRequest(request, new ListReadResponseParser());
    }

    public List listUpdate(ListUpdateRequest request) {
        return this.submitRequest(request, new ListReadResponseParser());
    }

    public ListMembershipQueryResponse.Result listMembershipQuery(ListMembershipQueryRequest request) {
        return this.submitRequest(request, new ListMembershipQueryResponseParser());
    }

    public ListMembership listMembershipRead(ListMembershipReadRequest request) {
        return this.submitRequest(request, new ListMembershipReadResponseParser());
    }

    public ListMembership listMembershipCreate(ListMembershipCreateRequest request) {
        return this.submitRequest(request, new ListMembershipReadResponseParser());
    }

    public ListMembership listMembershipUpdate(ListMembershipUpdateRequest request) {
        return this.submitRequest(request, new ListMembershipReadResponseParser());
    }

    public OpportunityQueryResponse.Result opportunityQuery(OpportunityQueryRequest request) {
        return this.submitRequest(request, new OpportunityQueryResponseParser());
    }

    public Opportunity opportunityRead(OpportunityReadRequest request) {
        return this.submitRequest(request, new OpportunityReadResponseParser());
    }

    public Opportunity opportunityCreate(OpportunityCreateRequest request) {
        return this.submitRequest(request, new OpportunityReadResponseParser());
    }

    public Opportunity opportunityUpdate(OpportunityUpdateRequest request) {
        return this.submitRequest(request, new OpportunityReadResponseParser());
    }

    public boolean opportunityDelete(OpportunityDeleteRequest request) {
        this.submitRequest(request, new StringResponseParser());
        return true;
    }

    public boolean opportunityUndelete(OpportunityUndeleteRequest request) {
        this.submitRequest(request, new StringResponseParser());
        return true;
    }

    public Prospect prospectRead(ProspectReadRequest request) {
        return this.submitRequest(request, new ProspectReadResponseParser());
    }

    public Prospect prospectCreate(ProspectCreateRequest request) {
        return this.submitRequest(request, new ProspectReadResponseParser());
    }

    public Prospect prospectUpdate(ProspectUpdateRequest request) {
        return this.submitRequest(request, new ProspectReadResponseParser());
    }

    public Prospect prospectUpsert(ProspectUpsertRequest request) {
        return this.submitRequest(request, new ProspectReadResponseParser());
    }

    public ProspectQueryResponse.Result prospectQuery(ProspectQueryRequest request) {
        return this.submitRequest(request, new ProspectQueryResponseParser());
    }

    public boolean prospectDelete(ProspectDeleteRequest request) {
        this.submitRequest(request, new StringResponseParser());
        return true;
    }

    public Prospect prospectAssign(ProspectAssignRequest request) {
        return this.submitRequest(request, new ProspectReadResponseParser());
    }

    public Prospect prospectUnassign(ProspectUnassignRequest request) {
        return this.submitRequest(request, new ProspectReadResponseParser());
    }

    public TagQueryResponse.Result tagQuery(TagQueryRequest request) {
        return this.submitRequest(request, new TagQueryResponseParser());
    }

    public Tag tagRead(TagReadRequest request) {
        return this.submitRequest(request, new TagReadResponseParser());
    }

    public TagObjectQueryResponse.Result tagObjectQuery(TagObjectQueryRequest request) {
        return this.submitRequest(request, new TagObjectQueryResponseParser());
    }

    public TagObject tagObjectRead(TagObjectReadRequest request) {
        return this.submitRequest(request, new TagObjectReadResponseParser());
    }

    public Visitor visitorAssign(VisitorAssignRequest request) {
        return this.submitRequest(request, new VisitorReadResponseParser());
    }

    public VisitorQueryResponse.Result visitorQuery(VisitorQueryRequest request) {
        return this.submitRequest(request, new VisitorQueryResponseParser());
    }

    public Visitor visitorRead(VisitorReadRequest request) {
        return this.submitRequest(request, new VisitorReadResponseParser());
    }

    public VisitorActivityQueryResponse.Result visitorActivityQuery(VisitorActivityQueryRequest request) {
        return this.submitRequest(request, new VisitorActivityQueryResponseParser());
    }

    public VisitorActivity visitorActivityRead(VisitorActivityReadRequest request) {
        return this.submitRequest(request, new VisitorActivityReadResponseParser());
    }

    @Override
    public void close() {
        this.getRestClient().close();
    }
}

