/*
 * Decompiled with CFR 0.152.
 */
package com.darksci.pardot.api;

public class Configuration {
    private final String email;
    private final String password;
    private final String userKey;
    private String apiKey = null;
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyScheme = "HTTP";
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String pardotApiHost = "https://pi.pardot.com/api";
    private String pardotApiVersion = "3";

    public Configuration(String email, String password, String userKey) {
        this.email = email;
        this.password = password;
        this.userKey = userKey;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public Configuration useProxy(String proxyHost, int proxyPort, String proxyScheme) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyScheme = proxyScheme;
        return this;
    }

    public Configuration useProxyAuthentication(String proxyUsername, String proxyPassword) {
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        return this;
    }

    public Configuration withApiVersion4() {
        this.pardotApiVersion = "4";
        return this;
    }

    public Configuration withApiVersion3() {
        this.pardotApiVersion = "3";
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getPardotApiHost() {
        return this.pardotApiHost;
    }

    public void setPardotApiHost(String pardotApiHost) {
        this.pardotApiHost = pardotApiHost;
    }

    public String getPardotApiVersion() {
        return this.pardotApiVersion;
    }

    public void setPardotApiVersion(String pardotApiVersion) {
        this.pardotApiVersion = pardotApiVersion;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Configuration{").append("email='").append(this.email).append('\'').append(", password='XXXXX'").append(", userKey='").append(this.userKey.substring(0, 3)).append("...'");
        if (this.proxyHost != null) {
            stringBuilder.append(", proxy='").append(this.proxyScheme).append("://");
            if (this.proxyUsername != null) {
                stringBuilder.append(this.proxyUsername).append(':').append("XXXXXXX@");
            }
            stringBuilder.append(this.proxyHost).append(":").append(this.proxyPort).append('\'');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

