/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.grpc;

import com.daml.grpc.adapter.ExecutionSequencerFactory;
import com.daml.ledger.api.v1.LedgerConfigurationServiceGrpc;
import com.daml.ledger.api.v1.LedgerConfigurationServiceOuterClass;
import com.daml.ledger.rxjava.LedgerConfigurationClient;
import com.daml.ledger.rxjava.grpc.helpers.StubHelper;
import com.daml.ledger.rxjava.util.ClientPublisherFlowable;
import io.grpc.Channel;
import io.reactivex.Flowable;
import java.util.Optional;

public class LedgerConfigurationClientImpl
implements LedgerConfigurationClient {
    private final String ledgerId;
    private final LedgerConfigurationServiceGrpc.LedgerConfigurationServiceStub serviceStub;
    private final ExecutionSequencerFactory sequencerFactory;

    public LedgerConfigurationClientImpl(String ledgerId, Channel channel, ExecutionSequencerFactory sequencerFactory, Optional<String> accessToken) {
        this.ledgerId = ledgerId;
        this.sequencerFactory = sequencerFactory;
        this.serviceStub = StubHelper.authenticating(LedgerConfigurationServiceGrpc.newStub((Channel)channel), accessToken);
    }

    private Flowable<LedgerConfigurationServiceOuterClass.LedgerConfiguration> getLedgerConfiguration(Optional<String> accessToken) {
        LedgerConfigurationServiceOuterClass.GetLedgerConfigurationRequest request = LedgerConfigurationServiceOuterClass.GetLedgerConfigurationRequest.newBuilder().setLedgerId(this.ledgerId).build();
        return ClientPublisherFlowable.create(request, (arg_0, arg_1) -> ((LedgerConfigurationServiceGrpc.LedgerConfigurationServiceStub)StubHelper.authenticating(this.serviceStub, accessToken)).getLedgerConfiguration(arg_0, arg_1), this.sequencerFactory).map(LedgerConfigurationServiceOuterClass.GetLedgerConfigurationResponse::getLedgerConfiguration);
    }

    @Override
    public Flowable<LedgerConfigurationServiceOuterClass.LedgerConfiguration> getLedgerConfiguration() {
        return this.getLedgerConfiguration(Optional.empty());
    }

    @Override
    public Flowable<LedgerConfigurationServiceOuterClass.LedgerConfiguration> getLedgerConfiguration(String accessToken) {
        return this.getLedgerConfiguration(Optional.of(accessToken));
    }
}

