/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.grpc;

import com.daml.ledger.api.v1.CommandSubmissionServiceGrpc;
import com.daml.ledger.api.v1.CommandSubmissionServiceOuterClass;
import com.daml.ledger.javaapi.data.Command;
import com.daml.ledger.javaapi.data.SubmitRequest;
import com.daml.ledger.rxjava.CommandSubmissionClient;
import com.daml.ledger.rxjava.grpc.helpers.StubHelper;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.reactivex.Single;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CommandSubmissionClientImpl
implements CommandSubmissionClient {
    private final String ledgerId;
    private final CommandSubmissionServiceGrpc.CommandSubmissionServiceFutureStub serviceStub;

    public CommandSubmissionClientImpl(@NonNull String ledgerId, @NonNull Channel channel, Optional<String> accessToken) {
        this.ledgerId = ledgerId;
        this.serviceStub = StubHelper.authenticating(CommandSubmissionServiceGrpc.newFutureStub((Channel)channel), accessToken);
    }

    public Single<Empty> submit(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, Optional<String> accessToken) {
        CommandSubmissionServiceOuterClass.SubmitRequest request = SubmitRequest.toProto((String)this.ledgerId, (String)workflowId, (String)applicationId, (String)commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands);
        return Single.fromFuture((Future)StubHelper.authenticating(this.serviceStub, accessToken).submit(request));
    }

    public Single<Empty> submit(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, Optional<String> accessToken) {
        return this.submit(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, accessToken);
    }

    @Override
    public Single<Empty> submit(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull List<@NonNull Command> commands) {
        return this.submit(workflowId, applicationId, commandId, party, Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.empty());
    }

    @Override
    public Single<Empty> submit(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull List<@NonNull Command> commands) {
        return this.submit(workflowId, applicationId, commandId, actAs, readAs, Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.empty());
    }

    @Override
    public Single<Empty> submit(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submit(workflowId, applicationId, commandId, party, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.of(accessToken));
    }

    @Override
    public Single<Empty> submit(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submit(workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.of(accessToken));
    }

    @Override
    public Single<Empty> submit(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        return this.submit(workflowId, applicationId, commandId, party, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.empty());
    }

    @Override
    public Single<Empty> submit(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        return this.submit(workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.empty());
    }

    @Override
    public Single<Empty> submit(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submit(workflowId, applicationId, commandId, party, Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.of(accessToken));
    }

    @Override
    public Single<Empty> submit(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submit(workflowId, applicationId, commandId, actAs, readAs, Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.of(accessToken));
    }
}

