/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.grpc;

import com.daml.ledger.api.v1.CommandServiceGrpc;
import com.daml.ledger.api.v1.CommandServiceOuterClass;
import com.daml.ledger.javaapi.data.Command;
import com.daml.ledger.javaapi.data.SubmitAndWaitRequest;
import com.daml.ledger.javaapi.data.Transaction;
import com.daml.ledger.javaapi.data.TransactionTree;
import com.daml.ledger.rxjava.CommandClient;
import com.daml.ledger.rxjava.grpc.helpers.StubHelper;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.reactivex.Single;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CommandClientImpl
implements CommandClient {
    private final String ledgerId;
    private final CommandServiceGrpc.CommandServiceFutureStub serviceStub;

    public CommandClientImpl(@NonNull String ledgerId, @NonNull Channel channel, @NonNull Optional<String> accessToken) {
        this.ledgerId = ledgerId;
        this.serviceStub = StubHelper.authenticating(CommandServiceGrpc.newFutureStub((Channel)channel), accessToken);
    }

    private Single<Empty> submitAndWait(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull Optional<String> accessToken) {
        CommandServiceOuterClass.SubmitAndWaitRequest request = SubmitAndWaitRequest.toProto((String)this.ledgerId, (String)workflowId, (String)applicationId, (String)commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands);
        return Single.fromFuture((Future)StubHelper.authenticating(this.serviceStub, accessToken).submitAndWait(request));
    }

    @Override
    public Single<Empty> submitAndWait(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWait(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.empty());
    }

    @Override
    public Single<Empty> submitAndWait(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWait(workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.empty());
    }

    @Override
    public Single<Empty> submitAndWait(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWait(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.of(accessToken));
    }

    @Override
    public Single<Empty> submitAndWait(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWait(workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.of(accessToken));
    }

    @Override
    public Single<Empty> submitAndWait(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWait(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.empty());
    }

    @Override
    public Single<Empty> submitAndWait(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWait(workflowId, applicationId, commandId, actAs, readAs, Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.empty());
    }

    @Override
    public Single<Empty> submitAndWait(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWait(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.of(accessToken));
    }

    @Override
    public Single<Empty> submitAndWait(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWait(workflowId, applicationId, commandId, actAs, readAs, Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.of(accessToken));
    }

    private Single<String> submitAndWaitForTransactionId(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull Optional<String> accessToken) {
        CommandServiceOuterClass.SubmitAndWaitRequest request = SubmitAndWaitRequest.toProto((String)this.ledgerId, (String)workflowId, (String)applicationId, (String)commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands);
        return Single.fromFuture((Future)StubHelper.authenticating(this.serviceStub, accessToken).submitAndWaitForTransactionId(request)).map(CommandServiceOuterClass.SubmitAndWaitForTransactionIdResponse::getTransactionId);
    }

    @Override
    public Single<String> submitAndWaitForTransactionId(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWaitForTransactionId(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.empty());
    }

    @Override
    public Single<String> submitAndWaitForTransactionId(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWaitForTransactionId(workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.empty());
    }

    @Override
    public Single<String> submitAndWaitForTransactionId(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWaitForTransactionId(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.of(accessToken));
    }

    @Override
    public Single<String> submitAndWaitForTransactionId(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWaitForTransactionId(workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.of(accessToken));
    }

    @Override
    public Single<String> submitAndWaitForTransactionId(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWaitForTransactionId(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.empty());
    }

    @Override
    public Single<String> submitAndWaitForTransactionId(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWaitForTransactionId(workflowId, applicationId, commandId, actAs, readAs, Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.empty());
    }

    @Override
    public Single<String> submitAndWaitForTransactionId(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWaitForTransactionId(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.of(accessToken));
    }

    @Override
    public Single<String> submitAndWaitForTransactionId(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWaitForTransactionId(workflowId, applicationId, commandId, actAs, readAs, Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.of(accessToken));
    }

    private Single<Transaction> submitAndWaitForTransaction(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull Optional<String> accessToken) {
        CommandServiceOuterClass.SubmitAndWaitRequest request = SubmitAndWaitRequest.toProto((String)this.ledgerId, (String)workflowId, (String)applicationId, (String)commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands);
        return Single.fromFuture((Future)StubHelper.authenticating(this.serviceStub, accessToken).submitAndWaitForTransaction(request)).map(CommandServiceOuterClass.SubmitAndWaitForTransactionResponse::getTransaction).map(Transaction::fromProto);
    }

    @Override
    public Single<Transaction> submitAndWaitForTransaction(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWaitForTransaction(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.empty());
    }

    @Override
    public Single<Transaction> submitAndWaitForTransaction(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWaitForTransaction(workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.empty());
    }

    @Override
    public Single<Transaction> submitAndWaitForTransaction(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWaitForTransaction(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.of(accessToken));
    }

    @Override
    public Single<Transaction> submitAndWaitForTransaction(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWaitForTransaction(workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.of(accessToken));
    }

    @Override
    public Single<Transaction> submitAndWaitForTransaction(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWaitForTransaction(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.empty());
    }

    @Override
    public Single<Transaction> submitAndWaitForTransaction(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWaitForTransaction(workflowId, applicationId, commandId, actAs, readAs, Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.empty());
    }

    @Override
    public Single<Transaction> submitAndWaitForTransaction(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWaitForTransaction(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.of(accessToken));
    }

    @Override
    public Single<Transaction> submitAndWaitForTransaction(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWaitForTransaction(workflowId, applicationId, commandId, actAs, readAs, Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.of(accessToken));
    }

    private Single<TransactionTree> submitAndWaitForTransactionTree(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull Optional<String> accessToken) {
        CommandServiceOuterClass.SubmitAndWaitRequest request = SubmitAndWaitRequest.toProto((String)this.ledgerId, (String)workflowId, (String)applicationId, (String)commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands);
        return Single.fromFuture((Future)StubHelper.authenticating(this.serviceStub, accessToken).submitAndWaitForTransactionTree(request)).map(CommandServiceOuterClass.SubmitAndWaitForTransactionTreeResponse::getTransaction).map(TransactionTree::fromProto);
    }

    @Override
    public Single<TransactionTree> submitAndWaitForTransactionTree(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWaitForTransactionTree(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.empty());
    }

    @Override
    public Single<TransactionTree> submitAndWaitForTransactionTree(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWaitForTransactionTree(workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.empty());
    }

    @Override
    public Single<TransactionTree> submitAndWaitForTransactionTree(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWaitForTransactionTree(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.of(accessToken));
    }

    @Override
    public Single<TransactionTree> submitAndWaitForTransactionTree(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbs, @NonNull Optional<Duration> minLedgerTimeRel, @NonNull Optional<Duration> deduplicationTime, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWaitForTransactionTree(workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, commands, Optional.of(accessToken));
    }

    @Override
    public Single<TransactionTree> submitAndWaitForTransactionTree(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWaitForTransactionTree(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.empty());
    }

    @Override
    public Single<TransactionTree> submitAndWaitForTransactionTree(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull List<@NonNull Command> commands) {
        return this.submitAndWaitForTransactionTree(workflowId, applicationId, commandId, actAs, readAs, Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.empty());
    }

    @Override
    public Single<TransactionTree> submitAndWaitForTransactionTree(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWaitForTransactionTree(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.of(accessToken));
    }

    @Override
    public Single<TransactionTree> submitAndWaitForTransactionTree(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull List<@NonNull Command> commands, @NonNull String accessToken) {
        return this.submitAndWaitForTransactionTree(workflowId, applicationId, commandId, actAs, readAs, Optional.empty(), Optional.empty(), Optional.empty(), commands, Optional.of(accessToken));
    }
}

