/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.components.helpers;

import com.daml.ledger.javaapi.data.Transaction;
import com.daml.ledger.rxjava.components.helpers.CreatedContractContext;
import java.time.Instant;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TransactionContext
implements CreatedContractContext {
    private final String transactionId;
    private final String commandId;
    private final String workflowId;
    private final Instant effectiveAt;
    private final String offset;

    public TransactionContext(@NonNull String transactionId, @NonNull String commandId, @NonNull String workflowId, @NonNull Instant effectiveAt, @NonNull String offset) {
        this.transactionId = transactionId;
        this.commandId = commandId;
        this.workflowId = workflowId;
        this.effectiveAt = effectiveAt;
        this.offset = offset;
    }

    public static TransactionContext forTransaction(@NonNull Transaction transaction) {
        @NonNull String commandId = transaction.getCommandId();
        @NonNull Instant effectiveAt = transaction.getEffectiveAt();
        @NonNull String offset = transaction.getOffset();
        @NonNull String transactionId = transaction.getTransactionId();
        @NonNull String workflowId = transaction.getWorkflowId();
        return new TransactionContext(transactionId, commandId, workflowId, effectiveAt, offset);
    }

    public @NonNull String getTransactionId() {
        return this.transactionId;
    }

    public @NonNull String getCommandId() {
        return this.commandId;
    }

    @Override
    public @NonNull String getWorkflowId() {
        return this.workflowId;
    }

    public @NonNull Instant getEffectiveAt() {
        return this.effectiveAt;
    }

    public @NonNull String getOffset() {
        return this.offset;
    }

    public String toString() {
        return "TransactionContext{transactionId='" + this.transactionId + '\'' + ", commandId='" + this.commandId + '\'' + ", workflowId='" + this.workflowId + '\'' + ", effectiveAt=" + this.effectiveAt + ", offset='" + this.offset + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionContext that = (TransactionContext)o;
        return Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.commandId, that.commandId) && Objects.equals(this.workflowId, that.workflowId) && Objects.equals(this.effectiveAt, that.effectiveAt) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.commandId, this.workflowId, this.effectiveAt, this.offset);
    }
}

