/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.components.helpers;

import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Record;
import com.daml.ledger.javaapi.data.Template;
import com.daml.ledger.javaapi.data.Value;
import com.daml.ledger.rxjava.components.helpers.CreatedContract;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.function.Function;

public class TemplateUtils {
    public static Function<CreatedContract, Template> contractTransformer(Class<? extends Template> ... allowedTemplates) {
        HashMap<Identifier, Method> factories = new HashMap<Identifier, Method>();
        for (Class<? extends Template> template : allowedTemplates) {
            try {
                Identifier identifier = (Identifier)template.getField("TEMPLATE_ID").get(null);
                Method method = template.getMethod("fromValue", Value.class);
                factories.put(identifier, method);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                throw new RuntimeException("Argument " + template + " should be derived from Template", e);
            }
        }
        return createdContract -> {
            if (!factories.containsKey(createdContract.getTemplateId())) {
                throw new IllegalStateException("Unknown contract of type " + createdContract.getTemplateId());
            }
            Record args = createdContract.getCreateArguments();
            Method method = (Method)factories.get(createdContract.getTemplateId());
            try {
                return (Template)method.invoke(null, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Argument " + method.getDeclaringClass() + " should be derived from Template", e);
            }
        };
    }
}

