/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava.components;

import com.daml.ledger.javaapi.data.ArchivedEvent;
import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.Event;
import com.daml.ledger.javaapi.data.GetActiveContractsResponse;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.LedgerOffset;
import com.daml.ledger.javaapi.data.Transaction;
import com.daml.ledger.javaapi.data.WorkflowEvent;
import com.daml.ledger.rxjava.components.helpers.CommandsAndPendingSet;
import com.daml.ledger.rxjava.components.helpers.CreatedContract;
import com.daml.ledger.rxjava.components.helpers.GetActiveContractsResponseContext;
import com.daml.ledger.rxjava.components.helpers.Pair;
import com.daml.ledger.rxjava.components.helpers.TransactionContext;
import com.google.rpc.Status;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.pcollections.HashTreePMap;
import org.pcollections.HashTreePSet;
import org.pcollections.PMap;
import org.pcollections.PSet;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerViewFlowable {
    private static final Logger logger = LoggerFactory.getLogger(LedgerViewFlowable.class);

    public static <R> Flowable<LedgerView<R>> of(LedgerView<R> initialLedgerView, Flowable<SubmissionFailure> submissionFailures, Flowable<CompletionFailure> completionFailures, Flowable<WorkflowEvent> workflowEvents, Flowable<CommandsAndPendingSet> commandsAndPendingsSet, Function<CreatedContract, R> transform) {
        Flowable workflowEventsWrapper = workflowEvents.map(WorkflowEventWrapper::new);
        Flowable commandIdAndPendingsSet = commandsAndPendingsSet.map(CommandIdAndPendingSet::from);
        Flowable all = Flowable.merge(submissionFailures, completionFailures, (Publisher)workflowEventsWrapper, (Publisher)commandIdAndPendingsSet);
        boolean shouldEmitInitial = !initialLedgerView.activeContractSet.isEmpty();
        StateWithShouldEmit<R> initialState = new StateWithShouldEmit<R>(initialLedgerView, 0, shouldEmitInitial);
        return all.scan(initialState, (input, state) -> LedgerViewFlowable.accumulate(input, state, transform)).filter(s -> s.shouldEmit).map(s -> s.ledgerView);
    }

    public static <R> Flowable<LedgerView<R>> of(Flowable<SubmissionFailure> submissionFailuresCommandIds, Flowable<CompletionFailure> completionFailuresCommandIds, Flowable<WorkflowEvent> workflowEvents, Flowable<CommandsAndPendingSet> commandsAndPendingsSet, Function<CreatedContract, R> transform) {
        return LedgerViewFlowable.of(LedgerView.create(), submissionFailuresCommandIds, completionFailuresCommandIds, workflowEvents, commandsAndPendingsSet, transform);
    }

    static <R> StateWithShouldEmit<R> accumulate(StateWithShouldEmit<R> stateWithShouldEmit, LedgerViewFlowableInput ledgerViewFlowableInput, Function<CreatedContract, R> transform) {
        logger.debug("LedgerView.accumulate({}, {})", stateWithShouldEmit, (Object)ledgerViewFlowableInput);
        if (ledgerViewFlowableInput instanceof SubmissionFailure) {
            SubmissionFailure submissionFailure = (SubmissionFailure)ledgerViewFlowableInput;
            LedgerView newLedgerView = stateWithShouldEmit.ledgerView.unsetPendingForContractsOfCommandId(submissionFailure.commandId);
            return stateWithShouldEmit.emit(newLedgerView);
        }
        if (ledgerViewFlowableInput instanceof CompletionFailure) {
            CompletionFailure completionFailure = (CompletionFailure)ledgerViewFlowableInput;
            LedgerView newLedgerView = stateWithShouldEmit.ledgerView.unsetPendingForContractsOfCommandId(completionFailure.commandId);
            if (newLedgerView.equals(stateWithShouldEmit.ledgerView)) {
                return stateWithShouldEmit;
            }
            logger.info("Command {} failed: {}", (Object)completionFailure.commandId, (Object)completionFailure.status);
            return stateWithShouldEmit.emit(newLedgerView);
        }
        if (ledgerViewFlowableInput instanceof WorkflowEventWrapper) {
            WorkflowEvent workflowEvent = ((WorkflowEventWrapper)ledgerViewFlowableInput).workflowEvent;
            if (workflowEvent instanceof Transaction) {
                Transaction transaction = (Transaction)workflowEvent;
                LedgerView<R> newLedgerView = stateWithShouldEmit.ledgerView;
                TransactionContext transactionContext = TransactionContext.forTransaction(transaction);
                for (Event event : transaction.getEvents()) {
                    if (event instanceof CreatedEvent) {
                        CreatedEvent createdEvent = (CreatedEvent)event;
                        R r = transform.apply(new CreatedContract(createdEvent.getTemplateId(), createdEvent.getArguments(), transactionContext));
                        newLedgerView = newLedgerView.addActiveContract(createdEvent.getTemplateId(), createdEvent.getContractId(), r);
                        continue;
                    }
                    if (!(event instanceof ArchivedEvent)) continue;
                    ArchivedEvent archivedEvent = (ArchivedEvent)event;
                    newLedgerView = newLedgerView.archiveContract(archivedEvent.getTemplateId(), archivedEvent.getContractId());
                }
                String commandId = transaction.getCommandId();
                newLedgerView = newLedgerView.unsetPendingForContractsOfCommandId(commandId);
                return stateWithShouldEmit.emit(newLedgerView);
            }
            if (workflowEvent instanceof GetActiveContractsResponse) {
                GetActiveContractsResponse activeContracts = (GetActiveContractsResponse)workflowEvent;
                LedgerView<R> newLedgerView = stateWithShouldEmit.ledgerView;
                GetActiveContractsResponseContext context = new GetActiveContractsResponseContext(activeContracts.getWorkflowId());
                for (CreatedEvent createdEvent : activeContracts.getCreatedEvents()) {
                    R r = transform.apply(new CreatedContract(createdEvent.getTemplateId(), createdEvent.getArguments(), context));
                    newLedgerView = newLedgerView.addActiveContract(createdEvent.getTemplateId(), createdEvent.getContractId(), r);
                }
                return stateWithShouldEmit.emit(newLedgerView);
            }
            throw new IllegalStateException(workflowEvent.toString());
        }
        if (ledgerViewFlowableInput instanceof CommandIdAndPendingSet) {
            CommandIdAndPendingSet commandIdAndPendingSet = (CommandIdAndPendingSet)ledgerViewFlowableInput;
            LedgerView newLedgerView = stateWithShouldEmit.ledgerView;
            for (Identifier templateId : commandIdAndPendingSet.templateToContracts.keySet()) {
                PSet contractIds = (PSet)commandIdAndPendingSet.templateToContracts.get((Object)templateId);
                for (String contractId : contractIds) {
                    newLedgerView = newLedgerView.setContractPending(commandIdAndPendingSet.commandId, templateId, contractId);
                }
                logger.debug("newLedgerView: {}", newLedgerView.getContracts(templateId));
            }
            boolean isBoundary = commandIdAndPendingSet.commandId.isEmpty();
            if (isBoundary) {
                return new StateWithShouldEmit(newLedgerView, 0, stateWithShouldEmit.commandsCounter > 0);
            }
            return new StateWithShouldEmit(newLedgerView, stateWithShouldEmit.commandsCounter + 1, false);
        }
        throw new IllegalStateException(stateWithShouldEmit.toString());
    }

    static <R> Single<Pair<LedgerView<R>, LedgerOffset>> ledgerViewAndOffsetFromACS(Flowable<GetActiveContractsResponse> responses, Function<CreatedContract, R> transform) {
        Single lastViewAndOffset = responses.reduce(new Pair(StateWithShouldEmit.create(), Optional.empty()), (viewAndOffset, response) -> {
            @NonNull StateWithShouldEmit ledgerView = (StateWithShouldEmit)viewAndOffset.getFirst();
            StateWithShouldEmit newLedgerView = LedgerViewFlowable.accumulate(ledgerView, new WorkflowEventWrapper((WorkflowEvent)response), transform);
            @NonNull Optional<LedgerOffset> offset = response.getOffset().map(off -> new LedgerOffset.Absolute(off));
            return new Pair(newLedgerView, offset);
        });
        return lastViewAndOffset.map(m -> new Pair(((StateWithShouldEmit)m.getFirst()).ledgerView, (LedgerOffset)((Optional)m.getSecond()).orElse(LedgerOffset.LedgerBegin.getInstance())));
    }

    static <R> Single<LedgerView<R>> ledgerViewFromFlowable(LedgerView<R> initial, Flowable<WorkflowEvent> events, Function<CreatedContract, R> transform) {
        return events.reduce(new StateWithShouldEmit<R>(initial, 0, false), (ledgerView, event) -> LedgerViewFlowable.accumulate(ledgerView, new WorkflowEventWrapper((WorkflowEvent)event), transform)).map(m -> m.ledgerView);
    }

    public static class LedgerTestView<R>
    extends LedgerView<R> {
        public LedgerTestView(PMap<String, PMap<Identifier, PSet<String>>> commandIdToContractIds, PMap<Identifier, PMap<String, PSet<String>>> contractIdsToCommandIds, PMap<Identifier, PMap<String, R>> pendingContractSet, PMap<Identifier, PMap<String, R>> activeContractSet) {
            super(commandIdToContractIds, contractIdsToCommandIds, pendingContractSet, activeContractSet);
        }

        @Override
        public LedgerTestView<R> addActiveContract(Identifier templateId, String contractId, R r) {
            LedgerView<R> lv = super.addActiveContract(templateId, contractId, r);
            return new LedgerTestView(lv.commandIdToContractIds, lv.contractIdsToCommandIds, lv.pendingContractSet, lv.activeContractSet);
        }
    }

    public static class LedgerView<R> {
        protected final PMap<String, PMap<Identifier, PSet<String>>> commandIdToContractIds;
        protected final PMap<Identifier, PMap<String, PSet<String>>> contractIdsToCommandIds;
        protected final PMap<Identifier, PMap<String, R>> pendingContractSet;
        protected final PMap<Identifier, PMap<String, R>> activeContractSet;

        LedgerView(PMap<String, PMap<Identifier, PSet<String>>> commandIdToContractIds, PMap<Identifier, PMap<String, PSet<String>>> contractIdsToCommandIds, PMap<Identifier, PMap<String, R>> pendingContractSet, PMap<Identifier, PMap<String, R>> activeContractSet) {
            this.commandIdToContractIds = commandIdToContractIds;
            this.contractIdsToCommandIds = contractIdsToCommandIds;
            this.pendingContractSet = pendingContractSet;
            this.activeContractSet = activeContractSet;
        }

        public static <R> LedgerView<R> create() {
            return new LedgerView<R>((PMap<String, PMap<Identifier, PSet<String>>>)HashTreePMap.empty(), (PMap<Identifier, PMap<String, PSet<String>>>)HashTreePMap.empty(), HashTreePMap.empty(), HashTreePMap.empty());
        }

        LedgerView<R> addActiveContract(Identifier templateId, String contractId, R r) {
            logger.debug("ledgerView.addActiveContract({}, {}, {})", new Object[]{templateId, contractId, r});
            PMap oldContractIdsToR = (PMap)this.activeContractSet.getOrDefault((Object)templateId, (Object)HashTreePMap.empty());
            PMap newContractIdsToR = oldContractIdsToR.plus((Object)contractId, r);
            PMap newActiveContractSet = this.activeContractSet.plus((Object)templateId, (Object)newContractIdsToR);
            return new LedgerView<R>(this.commandIdToContractIds, this.contractIdsToCommandIds, this.pendingContractSet, newActiveContractSet);
        }

        LedgerView<R> setContractPending(String commandId, Identifier templateId, String contractId) {
            logger.debug("ledgerView.setContractPending({}, {}, {})", new Object[]{commandId, templateId, contractId});
            PMap oldActiveContracts = (PMap)this.activeContractSet.getOrDefault((Object)templateId, (Object)HashTreePMap.empty());
            Object r = oldActiveContracts.get((Object)contractId);
            PMap newActiveContracts = oldActiveContracts.minus((Object)contractId);
            PMap newActiveContractSet = newActiveContracts.isEmpty() ? this.activeContractSet.minus((Object)templateId) : this.activeContractSet.plus((Object)templateId, (Object)newActiveContracts);
            PMap oldPendingContracts = (PMap)this.pendingContractSet.getOrDefault((Object)templateId, (Object)HashTreePMap.empty());
            PMap newPendingContracts = oldPendingContracts.plus((Object)contractId, r);
            PMap newPendingContractSet = this.pendingContractSet.plus((Object)templateId, (Object)newPendingContracts);
            PMap oldTemplateIdToContracts = (PMap)this.commandIdToContractIds.getOrDefault((Object)commandId, (Object)HashTreePMap.empty());
            PSet oldContracts = (PSet)oldTemplateIdToContracts.getOrDefault((Object)templateId, (Object)HashTreePSet.empty());
            PSet newContracts = oldContracts.plus((Object)contractId);
            PMap newTemplateIdToContracts = oldTemplateIdToContracts.plus((Object)templateId, (Object)newContracts);
            PMap newCommandIdToContracts = this.commandIdToContractIds.plus((Object)commandId, (Object)newTemplateIdToContracts);
            PMap oldContractToCommandIds = (PMap)this.contractIdsToCommandIds.getOrDefault((Object)templateId, (Object)HashTreePMap.empty());
            PSet oldCommandIds = (PSet)oldContractToCommandIds.getOrDefault((Object)contractId, (Object)HashTreePSet.empty());
            PSet newCommandIds = oldCommandIds.plus((Object)commandId);
            PMap newContractToCommandIds = oldContractToCommandIds.plus((Object)contractId, (Object)newCommandIds);
            PMap newContractIdsToCommandIds = this.contractIdsToCommandIds.plus((Object)templateId, (Object)newContractToCommandIds);
            LedgerView<R> result = new LedgerView<R>((PMap<String, PMap<Identifier, PSet<String>>>)newCommandIdToContracts, (PMap<Identifier, PMap<String, PSet<String>>>)newContractIdsToCommandIds, newPendingContractSet, newActiveContractSet);
            logger.debug("ledgerView.setContractPending({}, {}, {})).result: ", new Object[]{commandId, templateId, contractId, result});
            return result;
        }

        LedgerView<R> unsetPendingForContractsOfCommandId(String commandId) {
            logger.debug("ledgerView.unsetPendingForContractsOfCommandId({})", (Object)commandId);
            PMap newCommandIdToContractIds = this.commandIdToContractIds.minus((Object)commandId);
            PMap contractsToUnset = (PMap)this.commandIdToContractIds.getOrDefault((Object)commandId, (Object)HashTreePMap.empty());
            PMap newContractIdsToCommandIds = this.contractIdsToCommandIds;
            PMap newPendingContractSet = this.pendingContractSet;
            PMap newActiveContractSet = this.activeContractSet;
            for (Identifier templateId : contractsToUnset.keySet()) {
                PSet oldContractIds = (PSet)contractsToUnset.get((Object)templateId);
                PMap contractIdToCommandIds = (PMap)newContractIdsToCommandIds.getOrDefault((Object)templateId, (Object)HashTreePMap.empty());
                PMap pendingContractSet = (PMap)newPendingContractSet.getOrDefault((Object)templateId, (Object)HashTreePMap.empty());
                PMap activeContractSet = (PMap)newActiveContractSet.getOrDefault((Object)templateId, (Object)HashTreePMap.empty());
                for (String contractId : oldContractIds) {
                    PSet oldCommandIds = (PSet)contractIdToCommandIds.getOrDefault((Object)contractId, (Object)HashTreePSet.empty());
                    PSet newCommandIds = oldCommandIds.minus((Object)commandId);
                    if (newCommandIds.isEmpty()) {
                        contractIdToCommandIds = contractIdToCommandIds.minus((Object)contractId);
                        Object r = pendingContractSet.get((Object)contractId);
                        pendingContractSet = pendingContractSet.minus((Object)contractId);
                        activeContractSet = activeContractSet.plus((Object)contractId, r);
                        continue;
                    }
                    contractIdToCommandIds = contractIdToCommandIds.plus((Object)contractId, (Object)newCommandIds);
                }
                newContractIdsToCommandIds = contractIdToCommandIds.isEmpty() ? newContractIdsToCommandIds.minus((Object)templateId) : newContractIdsToCommandIds.plus((Object)templateId, (Object)contractIdToCommandIds);
                newPendingContractSet = pendingContractSet.isEmpty() ? newPendingContractSet.minus((Object)templateId) : newPendingContractSet.plus((Object)templateId, (Object)pendingContractSet);
                newActiveContractSet = activeContractSet.isEmpty() ? newActiveContractSet.minus((Object)templateId) : newActiveContractSet.plus((Object)templateId, (Object)activeContractSet);
            }
            return new LedgerView<R>((PMap<String, PMap<Identifier, PSet<String>>>)newCommandIdToContractIds, newContractIdsToCommandIds, newPendingContractSet, newActiveContractSet);
        }

        private static <R> PMap<Identifier, PMap<String, R>> removeContract(Identifier templateId, String contractId, PMap<Identifier, PMap<String, R>> from) {
            PMap oldActiveContracts;
            if (from.containsKey((Object)templateId) && (oldActiveContracts = (PMap)from.get((Object)templateId)).containsKey((Object)contractId)) {
                PMap newActiveContracts = oldActiveContracts.minus((Object)contractId);
                if (newActiveContracts.isEmpty()) {
                    return from.minus((Object)templateId);
                }
                return from.plus((Object)templateId, (Object)newActiveContracts);
            }
            return from;
        }

        LedgerView<R> archiveContract(Identifier templateId, String contractId) {
            PMap newContractIdsToCommandIds;
            PMap contractIdToCommandIds;
            logger.debug("ledgerView.archiveContract({}, {})", (Object)templateId, (Object)contractId);
            PMap<Identifier, PMap<String, R>> newPendingContractSet = LedgerView.removeContract(templateId, contractId, this.pendingContractSet);
            PMap<Identifier, PMap<String, R>> newActiveContractSet = LedgerView.removeContract(templateId, contractId, this.activeContractSet);
            PMap newCommandIdToContractIds = this.commandIdToContractIds;
            if (this.contractIdsToCommandIds.containsKey((Object)templateId) && (contractIdToCommandIds = (PMap)this.contractIdsToCommandIds.get((Object)templateId)).containsKey((Object)contractId)) {
                PSet commandIds = (PSet)contractIdToCommandIds.get((Object)contractId);
                for (String commandId : commandIds) {
                    PMap oldContracts = (PMap)newCommandIdToContractIds.getOrDefault((Object)commandId, (Object)HashTreePMap.empty());
                    PSet oldContractIds = (PSet)oldContracts.getOrDefault((Object)templateId, (Object)HashTreePSet.empty());
                    PSet newContractIds = oldContractIds.minus((Object)contractId);
                    PMap newContracts = newContractIds.isEmpty() ? oldContracts.minus((Object)templateId) : oldContracts.plus((Object)templateId, (Object)newContractIds);
                    newCommandIdToContractIds = newContracts.isEmpty() ? newCommandIdToContractIds.minus((Object)commandId) : newCommandIdToContractIds.plus((Object)commandId, (Object)newContracts);
                }
            }
            if ((newContractIdsToCommandIds = this.contractIdsToCommandIds).containsKey((Object)templateId)) {
                PMap oldContracts = (PMap)newContractIdsToCommandIds.get((Object)templateId);
                PMap newContracts = oldContracts.minus((Object)contractId);
                newContractIdsToCommandIds = newContracts.isEmpty() ? newContractIdsToCommandIds.minus((Object)templateId) : newContractIdsToCommandIds.plus((Object)templateId, (Object)newContracts);
            }
            return new LedgerView<R>(newCommandIdToContractIds, newContractIdsToCommandIds, newPendingContractSet, newActiveContractSet);
        }

        public PMap<String, R> getContracts(Identifier templateId) {
            return (PMap)this.activeContractSet.getOrDefault((Object)templateId, (Object)HashTreePMap.empty());
        }

        public String toString() {
            return "LedgerView{activeContractSet=" + this.activeContractSet + ", pendingContractSet=" + this.pendingContractSet + ", contractIdsToCommandIds=" + this.contractIdsToCommandIds + ", commandIdToContractIds=" + this.commandIdToContractIds + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LedgerView ledgerView = (LedgerView)o;
            return Objects.equals(this.commandIdToContractIds, ledgerView.commandIdToContractIds) && Objects.equals(this.contractIdsToCommandIds, ledgerView.contractIdsToCommandIds) && Objects.equals(this.pendingContractSet, ledgerView.pendingContractSet) && Objects.equals(this.activeContractSet, ledgerView.activeContractSet);
        }

        public int hashCode() {
            return Objects.hash(this.commandIdToContractIds, this.contractIdsToCommandIds, this.pendingContractSet, this.activeContractSet);
        }
    }

    private static class CommandIdAndPendingSet
    extends LedgerViewFlowableInput {
        final String commandId;
        final PMap<Identifier, PSet<String>> templateToContracts;

        public String toString() {
            return "CommandIdAndPendingSet{commandId='" + this.commandId + '\'' + ", templateToContracts=" + this.templateToContracts + '}';
        }

        public CommandIdAndPendingSet(String commandId, PMap<Identifier, PSet<String>> templateToContracts) {
            this.commandId = commandId;
            this.templateToContracts = templateToContracts;
        }

        public static CommandIdAndPendingSet from(CommandsAndPendingSet commandsAndPendingSet) {
            return new CommandIdAndPendingSet(commandsAndPendingSet.getSubmitCommandsRequest().getCommandId(), commandsAndPendingSet.getContractIdsPendingIfSucceed());
        }
    }

    static class WorkflowEventWrapper
    extends LedgerViewFlowableInput {
        final WorkflowEvent workflowEvent;

        public WorkflowEventWrapper(WorkflowEvent workflowEvent) {
            this.workflowEvent = workflowEvent;
        }

        public String toString() {
            return "WorkflowEventWrapper{workflowEvent=" + this.workflowEvent + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkflowEventWrapper that = (WorkflowEventWrapper)o;
            return Objects.equals(this.workflowEvent, that.workflowEvent);
        }

        public int hashCode() {
            return Objects.hash(this.workflowEvent);
        }
    }

    static class CompletionFailure
    extends LedgerViewFlowableInput {
        final String commandId;
        final Status status;

        CompletionFailure(String commandId, Status status) {
            this.commandId = commandId;
            this.status = status;
        }

        public String toString() {
            return "CompletionFailure{commandId='" + this.commandId + '\'' + ", status=" + this.status + '}';
        }
    }

    static class SubmissionFailure
    extends LedgerViewFlowableInput {
        final String commandId;
        final Throwable throwable;

        SubmissionFailure(String commandId, Throwable throwable) {
            this.commandId = commandId;
            this.throwable = throwable;
        }

        public String toString() {
            return "SubmissionFailure{commandId='" + this.commandId + '\'' + ", throwable=" + this.throwable + '}';
        }
    }

    static abstract class LedgerViewFlowableInput {
        LedgerViewFlowableInput() {
        }
    }

    private static class StateWithShouldEmit<R> {
        final LedgerView<R> ledgerView;
        final int commandsCounter;
        final boolean shouldEmit;

        public StateWithShouldEmit(LedgerView<R> ledgerView, int commandsCounter, boolean shouldEmit) {
            this.ledgerView = ledgerView;
            this.commandsCounter = commandsCounter;
            this.shouldEmit = shouldEmit;
        }

        public static <R> StateWithShouldEmit<R> create() {
            return new StateWithShouldEmit(LedgerView.create(), 0, false);
        }

        public static <R> StateWithShouldEmit<R> of(LedgerView<R> initialLedgerView) {
            return new StateWithShouldEmit<R>(initialLedgerView, 0, false);
        }

        public StateWithShouldEmit<R> emit(LedgerView<R> newLedgerView) {
            return new StateWithShouldEmit<R>(newLedgerView, this.commandsCounter, true);
        }

        public String toString() {
            return "StateWithShouldEmit{ledgerView=" + this.ledgerView + ", commandsCounter=" + this.commandsCounter + ", shouldEmit=" + this.shouldEmit + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateWithShouldEmit that = (StateWithShouldEmit)o;
            return this.commandsCounter == that.commandsCounter && this.shouldEmit == that.shouldEmit && Objects.equals(this.ledgerView, that.ledgerView);
        }

        public int hashCode() {
            return Objects.hash(this.ledgerView, this.commandsCounter, this.shouldEmit);
        }
    }
}

