/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.rxjava;

import com.daml.grpc.adapter.ExecutionSequencerFactory;
import com.daml.grpc.adapter.SingleThreadExecutionSequencerPool;
import com.daml.ledger.rxjava.ActiveContractsClient;
import com.daml.ledger.rxjava.CommandClient;
import com.daml.ledger.rxjava.CommandCompletionClient;
import com.daml.ledger.rxjava.CommandSubmissionClient;
import com.daml.ledger.rxjava.LedgerClient;
import com.daml.ledger.rxjava.LedgerConfigurationClient;
import com.daml.ledger.rxjava.LedgerIdentityClient;
import com.daml.ledger.rxjava.PackageClient;
import com.daml.ledger.rxjava.TimeClient;
import com.daml.ledger.rxjava.TransactionsClient;
import com.daml.ledger.rxjava.grpc.ActiveContractClientImpl;
import com.daml.ledger.rxjava.grpc.CommandClientImpl;
import com.daml.ledger.rxjava.grpc.CommandCompletionClientImpl;
import com.daml.ledger.rxjava.grpc.CommandSubmissionClientImpl;
import com.daml.ledger.rxjava.grpc.LedgerConfigurationClientImpl;
import com.daml.ledger.rxjava.grpc.LedgerIdentityClientImpl;
import com.daml.ledger.rxjava.grpc.PackageClientImpl;
import com.daml.ledger.rxjava.grpc.TimeClientImpl;
import com.daml.ledger.rxjava.grpc.TransactionClientImpl;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DamlLedgerClient
implements LedgerClient {
    private static final String DEFAULT_POOL_NAME = "client";
    private final SingleThreadExecutionSequencerPool pool = new SingleThreadExecutionSequencerPool("client");
    private ActiveContractsClient activeContractsClient;
    private TransactionsClient transactionsClient;
    private CommandCompletionClient commandCompletionClient;
    private CommandClient commandClient;
    private CommandSubmissionClient commandSubmissionClient;
    private LedgerIdentityClient ledgerIdentityClient;
    private PackageClient packageClient;
    private LedgerConfigurationClient ledgerConfigurationClient;
    private TimeClient timeClient;
    private String expectedLedgerId;
    private Optional<String> accessToken;
    private final ManagedChannel channel;

    public static Builder newBuilder(@NonNull String host, int port) {
        return new Builder(NettyChannelBuilder.forAddress((String)host, (int)port));
    }

    public static Builder newBuilder(@NonNull NettyChannelBuilder channelBuilder) {
        return new Builder(channelBuilder);
    }

    @Deprecated
    public static DamlLedgerClient forLedgerIdAndHost(@NonNull String ledgerId, @NonNull String hostIp, int hostPort, @NonNull Optional<SslContext> sslContext) {
        Builder builder = DamlLedgerClient.newBuilder(hostIp, hostPort).withExpectedLedgerId(ledgerId);
        sslContext.ifPresent(builder::withSslContext);
        return builder.build();
    }

    @Deprecated
    public static DamlLedgerClient forHostWithLedgerIdDiscovery(@NonNull String hostIp, int hostPort, Optional<SslContext> sslContext) {
        Builder builder = DamlLedgerClient.newBuilder(hostIp, hostPort);
        sslContext.ifPresent(builder::withSslContext);
        return builder.build();
    }

    private DamlLedgerClient(@NonNull NettyChannelBuilder channelBuilder, @NonNull Optional<String> expectedLedgerId, @NonNull Optional<String> accessToken) {
        this.channel = channelBuilder.build();
        this.expectedLedgerId = expectedLedgerId.orElse(null);
        this.accessToken = accessToken;
    }

    @Deprecated
    public DamlLedgerClient(Optional<String> expectedLedgerId, @NonNull ManagedChannel channel) {
        this.channel = channel;
        this.expectedLedgerId = expectedLedgerId.orElse(null);
        this.accessToken = Optional.empty();
    }

    public void connect() {
        this.ledgerIdentityClient = new LedgerIdentityClientImpl((Channel)this.channel, this.accessToken);
        String reportedLedgerId = (String)this.ledgerIdentityClient.getLedgerIdentity().blockingGet();
        if (this.expectedLedgerId != null && !this.expectedLedgerId.equals(reportedLedgerId)) {
            throw new IllegalArgumentException(String.format("Configured ledger id [%s] is not the same as reported by the ledger [%s]", this.expectedLedgerId, reportedLedgerId));
        }
        this.expectedLedgerId = reportedLedgerId;
        this.activeContractsClient = new ActiveContractClientImpl(reportedLedgerId, (Channel)this.channel, (ExecutionSequencerFactory)this.pool, this.accessToken);
        this.transactionsClient = new TransactionClientImpl(reportedLedgerId, (Channel)this.channel, (ExecutionSequencerFactory)this.pool, this.accessToken);
        this.commandCompletionClient = new CommandCompletionClientImpl(reportedLedgerId, (Channel)this.channel, (ExecutionSequencerFactory)this.pool, this.accessToken);
        this.commandSubmissionClient = new CommandSubmissionClientImpl(reportedLedgerId, (Channel)this.channel, this.accessToken);
        this.commandClient = new CommandClientImpl(reportedLedgerId, (Channel)this.channel, this.accessToken);
        this.packageClient = new PackageClientImpl(reportedLedgerId, (Channel)this.channel, this.accessToken);
        this.ledgerConfigurationClient = new LedgerConfigurationClientImpl(reportedLedgerId, (Channel)this.channel, (ExecutionSequencerFactory)this.pool, this.accessToken);
        this.timeClient = new TimeClientImpl(reportedLedgerId, (Channel)this.channel, (ExecutionSequencerFactory)this.pool, this.accessToken);
    }

    @Override
    public String getLedgerId() {
        return this.expectedLedgerId;
    }

    @Override
    public ActiveContractsClient getActiveContractSetClient() {
        return this.activeContractsClient;
    }

    @Override
    public TransactionsClient getTransactionsClient() {
        return this.transactionsClient;
    }

    @Override
    public CommandClient getCommandClient() {
        return this.commandClient;
    }

    @Override
    public CommandCompletionClient getCommandCompletionClient() {
        return this.commandCompletionClient;
    }

    @Override
    public CommandSubmissionClient getCommandSubmissionClient() {
        return this.commandSubmissionClient;
    }

    @Override
    public LedgerIdentityClient getLedgerIdentityClient() {
        return this.ledgerIdentityClient;
    }

    @Override
    public PackageClient getPackageClient() {
        return this.packageClient;
    }

    @Override
    public LedgerConfigurationClient getLedgerConfigurationClient() {
        return this.ledgerConfigurationClient;
    }

    @Override
    public TimeClient getTimeClient() {
        return this.timeClient;
    }

    public void close() throws Exception {
        this.channel.shutdownNow();
        this.channel.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        this.pool.close();
    }

    public static final class Builder {
        private final NettyChannelBuilder builder;
        private Optional<String> expectedLedgerId = Optional.empty();
        private Optional<String> accessToken = Optional.empty();

        private Builder(@NonNull NettyChannelBuilder channelBuilder) {
            this.builder = channelBuilder;
            this.builder.usePlaintext();
        }

        public Builder withSslContext(@NonNull SslContext sslContext) {
            this.builder.sslContext(sslContext);
            this.builder.useTransportSecurity();
            return this;
        }

        public Builder withExpectedLedgerId(@NonNull String expectedLedgerId) {
            this.expectedLedgerId = Optional.of(expectedLedgerId);
            return this;
        }

        public Builder withAccessToken(@NonNull String accessToken) {
            this.accessToken = Optional.of(accessToken);
            return this;
        }

        public DamlLedgerClient build() {
            return new DamlLedgerClient(this.builder, this.expectedLedgerId, this.accessToken);
        }
    }
}

